% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_delete_policy}
\alias{autoscaling_delete_policy}
\title{Deletes the specified scaling policy}
\usage{
autoscaling_delete_policy(AutoScalingGroupName, PolicyName)
}
\arguments{
\item{AutoScalingGroupName}{The name of the Auto Scaling group.}

\item{PolicyName}{[required] The name or Amazon Resource Name (ARN) of the policy.}
}
\description{
Deletes the specified scaling policy.
}
\details{
Deleting a policy deletes the underlying alarm action, but does not
delete the alarm, even if it no longer has an associated action.
}
\section{Request syntax}{
\preformatted{svc$delete_policy(
  AutoScalingGroupName = "string",
  PolicyName = "string"
)
}
}

\examples{
# This example deletes the specified Auto Scaling policy.
\donttest{svc$delete_policy(
  AutoScalingGroupName = "my-auto-scaling-group",
  PolicyName = "ScaleIn"
)}

}
\keyword{internal}
