% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_describe_raid_arrays}
\alias{opsworks_describe_raid_arrays}
\title{Describe an instance's RAID arrays}
\usage{
opsworks_describe_raid_arrays(InstanceId, StackId, RaidArrayIds)
}
\arguments{
\item{InstanceId}{The instance ID. If you use this parameter, \code{DescribeRaidArrays} returns
descriptions of the RAID arrays associated with the specified instance.}

\item{StackId}{The stack ID.}

\item{RaidArrayIds}{An array of RAID array IDs. If you use this parameter,
\code{DescribeRaidArrays} returns descriptions of the specified arrays.
Otherwise, it returns a description of every array.}
}
\description{
Describe an instance's RAID arrays.
}
\details{
This call accepts only one resource-identifying parameter.

\strong{Required Permissions}: To use this action, an IAM user must have a
Show, Deploy, or Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information about
user permissions, see \href{http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$describe_raid_arrays(
  InstanceId = "string",
  StackId = "string",
  RaidArrayIds = list(
    "string"
  )
)
}
}

\keyword{internal}
