% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_cancel_handshake}
\alias{organizations_cancel_handshake}
\title{Cancels a handshake}
\usage{
organizations_cancel_handshake(HandshakeId)
}
\arguments{
\item{HandshakeId}{[required] The unique identifier (ID) of the handshake that you want to cancel. You
can get the ID from the ListHandshakesForOrganization operation.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for handshake ID
string requires "h-" followed by from 8 to 32 lower-case letters or
digits.}
}
\description{
Cancels a handshake. Canceling a handshake sets the handshake state to
\code{CANCELED}.
}
\details{
This operation can be called only from the account that originated the
handshake. The recipient of the handshake can't cancel it, but can use
DeclineHandshake instead. After a handshake is canceled, the recipient
can no longer respond to that handshake.

After you cancel a handshake, it continues to appear in the results of
relevant APIs for only 30 days. After that it is deleted.
}
\section{Request syntax}{
\preformatted{svc$cancel_handshake(
  HandshakeId = "string"
)
}
}

\examples{
# Bill previously sent an invitation to Susan's account to join his
# organization. He changes his mind and decides to cancel the invitation
# before Susan accepts it. The following example shows Bill's
# cancellation:
# 
\donttest{svc$cancel_handshake(
  HandshakeId = "h-examplehandshakeid111"
)}

}
\keyword{internal}
