% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_move_account}
\alias{organizations_move_account}
\title{Moves an account from its current source parent root or organizational
unit (OU) to the specified destination parent root or OU}
\usage{
organizations_move_account(AccountId, SourceParentId,
  DestinationParentId)
}
\arguments{
\item{AccountId}{[required] The unique identifier (ID) of the account that you want to move.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for an account ID
string requires exactly 12 digits.}

\item{SourceParentId}{[required] The unique identifier (ID) of the root or organizational unit that you
want to move the account from.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for a parent ID
string requires one of the following:
\itemize{
\item Root: a string that begins with "r-" followed by from 4 to 32
lower-case letters or digits.
\item Organizational unit (OU): a string that begins with "ou-" followed
by from 4 to 32 lower-case letters or digits (the ID of the root
that the OU is in) followed by a second "-" dash and from 8 to 32
additional lower-case letters or digits.
}}

\item{DestinationParentId}{[required] The unique identifier (ID) of the root or organizational unit that you
want to move the account to.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for a parent ID
string requires one of the following:
\itemize{
\item Root: a string that begins with "r-" followed by from 4 to 32
lower-case letters or digits.
\item Organizational unit (OU): a string that begins with "ou-" followed
by from 4 to 32 lower-case letters or digits (the ID of the root
that the OU is in) followed by a second "-" dash and from 8 to 32
additional lower-case letters or digits.
}}
}
\description{
Moves an account from its current source parent root or organizational
unit (OU) to the specified destination parent root or OU.
}
\details{
This operation can be called only from the organization's master
account.
}
\section{Request syntax}{
\preformatted{svc$move_account(
  AccountId = "string",
  SourceParentId = "string",
  DestinationParentId = "string"
)
}
}

\examples{
# The following example shows how to move a member account from the root
# to an OU:/n/n
\donttest{svc$move_account(
  AccountId = "333333333333",
  DestinationParentId = "ou-examplerootid111-exampleouid111",
  SourceParentId = "r-examplerootid111"
)}

}
\keyword{internal}
