% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_send_automation_signal}
\alias{ssm_send_automation_signal}
\title{Sends a signal to an Automation execution to change the current behavior
or status of the execution}
\usage{
ssm_send_automation_signal(AutomationExecutionId, SignalType, Payload)
}
\arguments{
\item{AutomationExecutionId}{[required] The unique identifier for an existing Automation execution that you want
to send the signal to.}

\item{SignalType}{[required] The type of signal. Valid signal types include the following: Approve
and Reject}

\item{Payload}{The data sent with the signal. The data schema depends on the type of
signal used in the request.}
}
\description{
Sends a signal to an Automation execution to change the current behavior
or status of the execution.
}
\section{Request syntax}{
\preformatted{svc$send_automation_signal(
  AutomationExecutionId = "string",
  SignalType = "Approve"|"Reject"|"StartStep"|"StopStep"|"Resume",
  Payload = list(
    list(
      "string"
    )
  )
)
}
}

\keyword{internal}
