% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_cancel_update_stack}
\alias{cloudformation_cancel_update_stack}
\title{Cancels an update on the specified stack}
\usage{
cloudformation_cancel_update_stack(StackName, ClientRequestToken)
}
\arguments{
\item{StackName}{[required] The name or the unique stack ID that is associated with the stack.}

\item{ClientRequestToken}{A unique identifier for this \code{CancelUpdateStack} request. Specify this
token if you plan to retry requests so that AWS CloudFormation knows
that you're not attempting to cancel an update on a stack with the same
name. You might retry \code{CancelUpdateStack} requests to ensure that AWS
CloudFormation successfully received them.}
}
\description{
Cancels an update on the specified stack. If the call completes
successfully, the stack rolls back the update and reverts to the
previous stack configuration.

You can cancel only stacks that are in the UPDATE\\_IN\\_PROGRESS state.
}
\section{Request syntax}{
\preformatted{svc$cancel_update_stack(
  StackName = "string",
  ClientRequestToken = "string"
)
}
}

\keyword{internal}
