% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_deliver_config_snapshot}
\alias{configservice_deliver_config_snapshot}
\title{Schedules delivery of a configuration snapshot to the Amazon S3 bucket
in the specified delivery channel}
\usage{
configservice_deliver_config_snapshot(deliveryChannelName)
}
\arguments{
\item{deliveryChannelName}{[required] The name of the delivery channel through which the snapshot is
delivered.}
}
\description{
Schedules delivery of a configuration snapshot to the Amazon S3 bucket
in the specified delivery channel. After the delivery has started, AWS
Config sends the following notifications using an Amazon SNS topic that
you have specified.
\itemize{
\item Notification of the start of the delivery.
\item Notification of the completion of the delivery, if the delivery was
successfully completed.
\item Notification of delivery failure, if the delivery failed.
}
}
\section{Request syntax}{
\preformatted{svc$deliver_config_snapshot(
  deliveryChannelName = "string"
)
}
}

\keyword{internal}
