% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_describe_compliance_by_config_rule}
\alias{configservice_describe_compliance_by_config_rule}
\title{Indicates whether the specified AWS Config rules are compliant}
\usage{
configservice_describe_compliance_by_config_rule(ConfigRuleNames,
  ComplianceTypes, NextToken)
}
\arguments{
\item{ConfigRuleNames}{Specify one or more AWS Config rule names to filter the results by rule.}

\item{ComplianceTypes}{Filters the results by compliance.

The allowed values are \code{COMPLIANT} and \code{NON_COMPLIANT}.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Indicates whether the specified AWS Config rules are compliant. If a
rule is noncompliant, this action returns the number of AWS resources
that do not comply with the rule.

A rule is compliant if all of the evaluated resources comply with it. It
is noncompliant if any of these resources do not comply.

If AWS Config has no current evaluation results for the rule, it returns
\code{INSUFFICIENT_DATA}. This result might indicate one of the following
conditions:
\itemize{
\item AWS Config has never invoked an evaluation for the rule. To check
whether it has, use the \code{DescribeConfigRuleEvaluationStatus} action
to get the \code{LastSuccessfulInvocationTime} and
\code{LastFailedInvocationTime}.
\item The rule's AWS Lambda function is failing to send evaluation results
to AWS Config. Verify that the role you assigned to your
configuration recorder includes the \code{config:PutEvaluations}
permission. If the rule is a custom rule, verify that the AWS Lambda
execution role includes the \code{config:PutEvaluations} permission.
\item The rule's AWS Lambda function has returned \code{NOT_APPLICABLE} for all
evaluation results. This can occur if the resources were deleted or
removed from the rule's scope.
}
}
\section{Request syntax}{
\preformatted{svc$describe_compliance_by_config_rule(
  ConfigRuleNames = list(
    "string"
  ),
  ComplianceTypes = list(
    "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA"
  ),
  NextToken = "string"
)
}
}

\keyword{internal}
