% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health_operations.R
\name{health_describe_event_details_for_organization}
\alias{health_describe_event_details_for_organization}
\title{Returns detailed information about one or more specified events for one
or more accounts in your organization}
\usage{
health_describe_event_details_for_organization(
  organizationEventDetailFilters, locale)
}
\arguments{
\item{organizationEventDetailFilters}{[required] A set of JSON elements that includes the \code{awsAccountId} and the
\code{eventArn}.}

\item{locale}{The locale (language) to return information in. English (en) is the
default and the only supported value at this time.}
}
\description{
Returns detailed information about one or more specified events for one
or more accounts in your organization. Information includes standard
event data (Region, service, and so on, as returned by
\href{https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventsForOrganization.html}{DescribeEventsForOrganization}),
a detailed event description, and possible additional metadata that
depends upon the nature of the event. Affected entities are not
included; to retrieve those, use the
\href{https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntitiesForOrganization.html}{DescribeAffectedEntitiesForOrganization}
operation.

Before you can call this operation, you must first enable AWS Health to
work with AWS Organizations. To do this, call the
\href{https://docs.aws.amazon.com/health/latest/APIReference/API_EnableHealthServiceAccessForOrganization.html}{EnableHealthServiceAccessForOrganization}
operation from your organization's master account.

When you call the \code{DescribeEventDetailsForOrganization} operation, you
specify the \code{organizationEventDetailFilters} object in the request.
Depending on the AWS Health event type, note the following differences:
\itemize{
\item If the event is public, the \code{awsAccountId} parameter must be empty.
If you specify an account ID for a public event, then an error
message is returned. That's because the event might apply to all AWS
accounts and isn't specific to an account in your organization.
\item If the event is specific to an account, then you must specify the
\code{awsAccountId} parameter in the request. If you don't specify an
account ID, an error message returns because the event is specific
to an AWS account in your organization.
}

For more information, see
\href{https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html}{Event}.
}
\section{Request syntax}{
\preformatted{svc$describe_event_details_for_organization(
  organizationEventDetailFilters = list(
    list(
      eventArn = "string",
      awsAccountId = "string"
    )
  ),
  locale = "string"
)
}
}

\keyword{internal}
