% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_create_grant}
\alias{licensemanager_create_grant}
\title{Creates a grant for the specified license}
\usage{
licensemanager_create_grant(ClientToken, GrantName, LicenseArn,
  Principals, HomeRegion, AllowedOperations)
}
\arguments{
\item{ClientToken}{[required] Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{GrantName}{[required] Grant name.}

\item{LicenseArn}{[required] Amazon Resource Name (ARN) of the license.}

\item{Principals}{[required] The grant principals.}

\item{HomeRegion}{[required] Home Region of the grant.}

\item{AllowedOperations}{[required] Allowed operations for the grant.}
}
\description{
Creates a grant for the specified license. A grant shares the use of
license entitlements with specific AWS accounts.
}
\section{Request syntax}{
\preformatted{svc$create_grant(
  ClientToken = "string",
  GrantName = "string",
  LicenseArn = "string",
  Principals = list(
    "string"
  ),
  HomeRegion = "string",
  AllowedOperations = list(
    "CreateGrant"|"CheckoutLicense"|"CheckoutBorrowLicense"|"CheckInLicense"|"ExtendConsumptionLicense"|"ListPurchasedLicenses"|"CreateToken"
  )
)
}
}

\keyword{internal}
