% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_list_accepted_portfolio_shares}
\alias{servicecatalog_list_accepted_portfolio_shares}
\title{Lists all portfolios for which sharing was accepted by this account}
\usage{
servicecatalog_list_accepted_portfolio_shares(AcceptLanguage, PageToken,
  PageSize, PortfolioShareType)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{PageToken}{The page token for the next set of results. To retrieve the first set of
results, use null.}

\item{PageSize}{The maximum number of items to return with this call.}

\item{PortfolioShareType}{The type of shared portfolios to list. The default is to list imported
portfolios.
\itemize{
\item \code{AWS_ORGANIZATIONS} - List portfolios shared by the management
account of your organization
\item \code{AWS_SERVICECATALOG} - List default portfolios
\item \code{IMPORTED} - List imported portfolios
}}
}
\description{
Lists all portfolios for which sharing was accepted by this account.
}
\section{Request syntax}{
\preformatted{svc$list_accepted_portfolio_shares(
  AcceptLanguage = "string",
  PageToken = "string",
  PageSize = 123,
  PortfolioShareType = "IMPORTED"|"AWS_SERVICECATALOG"|"AWS_ORGANIZATIONS"
)
}
}

\keyword{internal}
