% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_service_setting}
\alias{ssm_get_service_setting}
\title{ServiceSetting is an account-level setting for an AWS service}
\usage{
ssm_get_service_setting(SettingId)
}
\arguments{
\item{SettingId}{[required] The ID of the service setting to get. The setting ID can be
\verb{/ssm/parameter-store/default-parameter-tier},
\verb{/ssm/parameter-store/high-throughput-enabled}, or
\verb{/ssm/managed-instance/activation-tier}.}
}
\description{
\code{ServiceSetting} is an account-level setting for an AWS service. This
setting defines how a user interacts with or uses a service or a feature
of a service. For example, if an AWS service charges money to the
account based on feature or service usage, then the AWS service team
might create a default setting of "false". This means the user can't use
this feature unless they change the setting to "true" and intentionally
opt in for a paid feature.

Services map a \code{SettingId} object to a setting value. AWS services teams
define the default value for a \code{SettingId}. You can't create a new
\code{SettingId}, but you can overwrite the default value if you have the
\code{ssm:UpdateServiceSetting} permission for the setting. Use the
UpdateServiceSetting API action to change the default setting. Or use
the ResetServiceSetting to change the value back to the original value
defined by the AWS service team.

Query the current service setting for the account.
}
\section{Request syntax}{
\preformatted{svc$get_service_setting(
  SettingId = "string"
)
}
}

\keyword{internal}
