% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_update_trail}
\alias{cloudtrail_update_trail}
\title{Updates the settings that specify delivery of log files}
\usage{
cloudtrail_update_trail(Name, S3BucketName, S3KeyPrefix, SnsTopicName,
  IncludeGlobalServiceEvents, IsMultiRegionTrail, EnableLogFileValidation,
  CloudWatchLogsLogGroupArn, CloudWatchLogsRoleArn, KmsKeyId,
  IsOrganizationTrail)
}
\arguments{
\item{Name}{[required] Specifies the name of the trail or trail ARN. If \code{Name} is a trail name,
the string must meet the following requirements:
\itemize{
\item Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
underscores (_), or dashes (-)
\item Start with a letter or number, and end with a letter or number
\item Be between 3 and 128 characters
\item Have no adjacent periods, underscores or dashes. Names like
\verb{my-_namespace} and \code{my--namespace} are invalid.
\item Not be in IP address format (for example, 192.168.5.4)
}

If \code{Name} is a trail ARN, it must be in the format:

\code{arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail}}

\item{S3BucketName}{Specifies the name of the Amazon S3 bucket designated for publishing log
files. See \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-s3-bucket-naming-requirements.html}{Amazon S3 Bucket Naming Requirements}.}

\item{S3KeyPrefix}{Specifies the Amazon S3 key prefix that comes after the name of the
bucket you have designated for log file delivery. For more information,
see \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html}{Finding Your CloudTrail Log Files}.
The maximum length is 200 characters.}

\item{SnsTopicName}{Specifies the name of the Amazon SNS topic defined for notification of
log file delivery. The maximum length is 256 characters.}

\item{IncludeGlobalServiceEvents}{Specifies whether the trail is publishing events from global services
such as IAM to the log files.}

\item{IsMultiRegionTrail}{Specifies whether the trail applies only to the current region or to all
regions. The default is false. If the trail exists only in the current
region and this value is set to true, shadow trails (replications of the
trail) will be created in the other regions. If the trail exists in all
regions and this value is set to false, the trail will remain in the
region where it was created, and its shadow trails in other regions will
be deleted. As a best practice, consider using trails that log events in
all regions.}

\item{EnableLogFileValidation}{Specifies whether log file validation is enabled. The default is false.

When you disable log file integrity validation, the chain of digest
files is broken after one hour. CloudTrail will not create digest files
for log files that were delivered during a period in which log file
integrity validation was disabled. For example, if you enable log file
integrity validation at noon on January 1, disable it at noon on January
2, and re-enable it at noon on January 10, digest files will not be
created for the log files delivered from noon on January 2 to noon on
January 10. The same applies whenever you stop CloudTrail logging or
delete a trail.}

\item{CloudWatchLogsLogGroupArn}{Specifies a log group name using an Amazon Resource Name (ARN), a unique
identifier that represents the log group to which CloudTrail logs will
be delivered. Not required unless you specify CloudWatchLogsRoleArn.}

\item{CloudWatchLogsRoleArn}{Specifies the role for the CloudWatch Logs endpoint to assume to write
to a user's log group.}

\item{KmsKeyId}{Specifies the KMS key ID to use to encrypt the logs delivered by
CloudTrail. The value can be an alias name prefixed by "alias/", a fully
specified ARN to an alias, a fully specified ARN to a key, or a globally
unique identifier.

Examples:
\itemize{
\item alias/MyAliasName
\item arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
\item arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
\item 12345678-1234-1234-1234-123456789012
}}

\item{IsOrganizationTrail}{Specifies whether the trail is applied to all accounts in an
organization in AWS Organizations, or only for the current AWS account.
The default is false, and cannot be true unless the call is made on
behalf of an AWS account that is the master account for an organization
in AWS Organizations. If the trail is not an organization trail and this
is set to true, the trail will be created in all AWS accounts that
belong to the organization. If the trail is an organization trail and
this is set to false, the trail will remain in the current AWS account
but be deleted from all member accounts in the organization.}
}
\value{
A list with the following syntax:\preformatted{list(
  Name = "string",
  S3BucketName = "string",
  S3KeyPrefix = "string",
  SnsTopicName = "string",
  SnsTopicARN = "string",
  IncludeGlobalServiceEvents = TRUE|FALSE,
  IsMultiRegionTrail = TRUE|FALSE,
  TrailARN = "string",
  LogFileValidationEnabled = TRUE|FALSE,
  CloudWatchLogsLogGroupArn = "string",
  CloudWatchLogsRoleArn = "string",
  KmsKeyId = "string",
  IsOrganizationTrail = TRUE|FALSE
)
}
}
\description{
Updates the settings that specify delivery of log files. Changes to a
trail do not require stopping the CloudTrail service. Use this action to
designate an existing bucket for log delivery. If the existing bucket
has previously been a target for CloudTrail log files, an IAM policy
exists for the bucket. \code{\link[=cloudtrail_update_trail]{update_trail}} must be
called from the region in which the trail was created; otherwise, an
\code{InvalidHomeRegionException} is thrown.
}
\section{Request syntax}{
\preformatted{svc$update_trail(
  Name = "string",
  S3BucketName = "string",
  S3KeyPrefix = "string",
  SnsTopicName = "string",
  IncludeGlobalServiceEvents = TRUE|FALSE,
  IsMultiRegionTrail = TRUE|FALSE,
  EnableLogFileValidation = TRUE|FALSE,
  CloudWatchLogsLogGroupArn = "string",
  CloudWatchLogsRoleArn = "string",
  KmsKeyId = "string",
  IsOrganizationTrail = TRUE|FALSE
)
}
}

\keyword{internal}
