% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_describe_destinations}
\alias{cloudwatchlogs_describe_destinations}
\title{Lists all your destinations}
\usage{
cloudwatchlogs_describe_destinations(DestinationNamePrefix, nextToken,
  limit)
}
\arguments{
\item{DestinationNamePrefix}{The prefix to match. If you don't specify a value, no prefix filter is
applied.}

\item{nextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{limit}{The maximum number of items returned. If you don't specify a value, the
default is up to 50 items.}
}
\value{
A list with the following syntax:\preformatted{list(
  destinations = list(
    list(
      destinationName = "string",
      targetArn = "string",
      roleArn = "string",
      accessPolicy = "string",
      arn = "string",
      creationTime = 123
    )
  ),
  nextToken = "string"
)
}
}
\description{
Lists all your destinations. The results are ASCII-sorted by destination
name.
}
\section{Request syntax}{
\preformatted{svc$describe_destinations(
  DestinationNamePrefix = "string",
  nextToken = "string",
  limit = 123
)
}
}

\keyword{internal}
