% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_register_delegated_administrator}
\alias{organizations_register_delegated_administrator}
\title{Enables the specified member account to administer the Organizations
features of the specified AWS service}
\usage{
organizations_register_delegated_administrator(AccountId,
  ServicePrincipal)
}
\arguments{
\item{AccountId}{[required] The account ID number of the member account in the organization to
register as a delegated administrator.}

\item{ServicePrincipal}{[required] The service principal of the AWS service for which you want to make the
member account a delegated administrator.}
}
\value{
An empty list.
}
\description{
Enables the specified member account to administer the Organizations
features of the specified AWS service. It grants read-only access to AWS
Organizations service data. The account still requires IAM permissions
to access and administer the AWS service.

You can run this action only for AWS services that support this feature.
For a current list of services that support it, see the column \emph{Supports
Delegated Administrator} in the table at \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html}{AWS Services that you can use with AWS Organizations}
in the \emph{AWS Organizations User Guide.}

This operation can be called only from the organization's management
account.
}
\section{Request syntax}{
\preformatted{svc$register_delegated_administrator(
  AccountId = "string",
  ServicePrincipal = "string"
)
}
}

\keyword{internal}
