% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_remove_tags_from_resource}
\alias{ssm_remove_tags_from_resource}
\title{Removes tag keys from the specified resource}
\usage{
ssm_remove_tags_from_resource(ResourceType, ResourceId, TagKeys)
}
\arguments{
\item{ResourceType}{[required] The type of resource from which you want to remove a tag.

The ManagedInstance type for this API action is only for on-premises
managed instances. Specify the name of the managed instance in the
following format: mi-ID_number. For example, mi-1a2b3c4d5e6f.}

\item{ResourceId}{[required] The ID of the resource from which you want to remove tags. For example:

ManagedInstance: mi-012345abcde

MaintenanceWindow: mw-012345abcde

PatchBaseline: pb-012345abcde

For the Document and Parameter values, use the name of the resource.

The ManagedInstance type for this API action is only for on-premises
managed instances. Specify the name of the managed instance in the
following format: mi-ID_number. For example, mi-1a2b3c4d5e6f.}

\item{TagKeys}{[required] Tag keys that you want to remove from the specified resource.}
}
\value{
An empty list.
}
\description{
Removes tag keys from the specified resource.
}
\section{Request syntax}{
\preformatted{svc$remove_tags_from_resource(
  ResourceType = "Document"|"ManagedInstance"|"MaintenanceWindow"|"Parameter"|"PatchBaseline"|"OpsItem",
  ResourceId = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
