% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_detach_load_balancer_target_groups}
\alias{autoscaling_detach_load_balancer_target_groups}
\title{Detaches one or more target groups from the specified Auto Scaling group}
\usage{
autoscaling_detach_load_balancer_target_groups(AutoScalingGroupName,
  TargetGroupARNs)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{TargetGroupARNs}{[required] The Amazon Resource Names (ARN) of the target groups. You can specify up
to 10 target groups.}
}
\value{
An empty list.
}
\description{
Detaches one or more target groups from the specified Auto Scaling
group.
}
\section{Request syntax}{
\preformatted{svc$detach_load_balancer_target_groups(
  AutoScalingGroupName = "string",
  TargetGroupARNs = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example detaches the specified target group from the specified Auto
# Scaling group
svc$detach_load_balancer_target_groups(
  AutoScalingGroupName = "my-auto-scaling-group",
  TargetGroupARNs = list(
    "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-tar..."
  )
)
}

}
\keyword{internal}
