% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscalingplans_operations.R
\name{autoscalingplans_get_scaling_plan_resource_forecast_data}
\alias{autoscalingplans_get_scaling_plan_resource_forecast_data}
\title{Retrieves the forecast data for a scalable resource}
\usage{
autoscalingplans_get_scaling_plan_resource_forecast_data(
  ScalingPlanName, ScalingPlanVersion, ServiceNamespace, ResourceId,
  ScalableDimension, ForecastDataType, StartTime, EndTime)
}
\arguments{
\item{ScalingPlanName}{[required] The name of the scaling plan.}

\item{ScalingPlanVersion}{[required] The version number of the scaling plan. Currently, the only valid value
is \code{1}.}

\item{ServiceNamespace}{[required] The namespace of the AWS service. The only valid value is \code{autoscaling}.}

\item{ResourceId}{[required] The ID of the resource. This string consists of a prefix
(\code{autoScalingGroup}) followed by the name of a specified Auto Scaling
group (\code{my-asg}). Example: \code{autoScalingGroup/my-asg}.}

\item{ScalableDimension}{[required] The scalable dimension for the resource. The only valid value is
\code{autoscaling:autoScalingGroup:DesiredCapacity}.}

\item{ForecastDataType}{[required] The type of forecast data to get.
\itemize{
\item \code{LoadForecast}: The load metric forecast.
\item \code{CapacityForecast}: The capacity forecast.
\item \code{ScheduledActionMinCapacity}: The minimum capacity for each
scheduled scaling action. This data is calculated as the larger of
two values: the capacity forecast or the minimum capacity in the
scaling instruction.
\item \code{ScheduledActionMaxCapacity}: The maximum capacity for each
scheduled scaling action. The calculation used is determined by the
predictive scaling maximum capacity behavior setting in the scaling
instruction.
}}

\item{StartTime}{[required] The inclusive start time of the time range for the forecast data to get.
The date and time can be at most 56 days before the current date and
time.}

\item{EndTime}{[required] The exclusive end time of the time range for the forecast data to get.
The maximum time duration between the start and end time is seven days.

Although this parameter can accept a date and time that is more than two
days in the future, the availability of forecast data has limits. AWS
Auto Scaling only issues forecasts for periods of two days in advance.}
}
\value{
A list with the following syntax:\preformatted{list(
  Datapoints = list(
    list(
      Timestamp = as.POSIXct(
        "2015-01-01"
      ),
      Value = 123.0
    )
  )
)
}
}
\description{
Retrieves the forecast data for a scalable resource.

Capacity forecasts are represented as predicted values, or data points,
that are calculated using historical data points from a specified
CloudWatch load metric. Data points are available for up to 56 days.
}
\section{Request syntax}{
\preformatted{svc$get_scaling_plan_resource_forecast_data(
  ScalingPlanName = "string",
  ScalingPlanVersion = 123,
  ServiceNamespace = "autoscaling"|"ecs"|"ec2"|"rds"|"dynamodb",
  ResourceId = "string",
  ScalableDimension = "autoscaling:autoScalingGroup:DesiredCapacity"|"ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"rds:cluster:ReadReplicaCount"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits",
  ForecastDataType = "CapacityForecast"|"LoadForecast"|"ScheduledActionMinCapacity"|"ScheduledActionMaxCapacity",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
