% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_describe_stack_set}
\alias{cloudformation_describe_stack_set}
\title{Returns the description of the specified stack set}
\usage{
cloudformation_describe_stack_set(StackSetName)
}
\arguments{
\item{StackSetName}{[required] The name or unique ID of the stack set whose description you want.}
}
\value{
A list with the following syntax:\preformatted{list(
  StackSet = list(
    StackSetName = "string",
    StackSetId = "string",
    Description = "string",
    Status = "ACTIVE"|"DELETED",
    TemplateBody = "string",
    Parameters = list(
      list(
        ParameterKey = "string",
        ParameterValue = "string",
        UsePreviousValue = TRUE|FALSE,
        ResolvedValue = "string"
      )
    ),
    Capabilities = list(
      "CAPABILITY_IAM"|"CAPABILITY_NAMED_IAM"|"CAPABILITY_AUTO_EXPAND"
    ),
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    StackSetARN = "string",
    AdministrationRoleARN = "string",
    ExecutionRoleName = "string",
    StackSetDriftDetectionDetails = list(
      DriftStatus = "DRIFTED"|"IN_SYNC"|"NOT_CHECKED",
      DriftDetectionStatus = "COMPLETED"|"FAILED"|"PARTIAL_SUCCESS"|"IN_PROGRESS"|"STOPPED",
      LastDriftCheckTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      TotalStackInstancesCount = 123,
      DriftedStackInstancesCount = 123,
      InSyncStackInstancesCount = 123,
      InProgressStackInstancesCount = 123,
      FailedStackInstancesCount = 123
    ),
    AutoDeployment = list(
      Enabled = TRUE|FALSE,
      RetainStacksOnAccountRemoval = TRUE|FALSE
    ),
    PermissionModel = "SERVICE_MANAGED"|"SELF_MANAGED",
    OrganizationalUnitIds = list(
      "string"
    )
  )
)
}
}
\description{
Returns the description of the specified stack set.
}
\section{Request syntax}{
\preformatted{svc$describe_stack_set(
  StackSetName = "string"
)
}
}

\keyword{internal}
