% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_filter_log_events}
\alias{cloudwatchlogs_filter_log_events}
\title{Lists log events from the specified log group}
\usage{
cloudwatchlogs_filter_log_events(logGroupName, logStreamNames,
  logStreamNamePrefix, startTime, endTime, filterPattern, nextToken,
  limit, interleaved)
}
\arguments{
\item{logGroupName}{[required] The name of the log group to search.}

\item{logStreamNames}{Filters the results to only logs from the log streams in this list.

If you specify a value for both \code{logStreamNamePrefix} and
\code{logStreamNames}, the action returns an \code{InvalidParameterException}
error.}

\item{logStreamNamePrefix}{Filters the results to include only events from log streams that have
names starting with this prefix.

If you specify a value for both \code{logStreamNamePrefix} and
\code{logStreamNames}, but the value for \code{logStreamNamePrefix} does not match
any log stream names specified in \code{logStreamNames}, the action returns
an \code{InvalidParameterException} error.}

\item{startTime}{The start of the time range, expressed as the number of milliseconds
after Jan 1, 1970 00:00:00 UTC. Events with a timestamp before this time
are not returned.

If you omit \code{startTime} and \code{endTime} the most recent log events are
retrieved, to up 1 MB or 10,000 log events.}

\item{endTime}{The end of the time range, expressed as the number of milliseconds after
Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time
are not returned.}

\item{filterPattern}{The filter pattern to use. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html}{Filter and Pattern Syntax}.

If not provided, all the events are matched.}

\item{nextToken}{The token for the next set of events to return. (You received this token
from a previous call.)}

\item{limit}{The maximum number of events to return. The default is 10,000 events.}

\item{interleaved}{If the value is true, the operation makes a best effort to provide
responses that contain events from multiple log streams within the log
group, interleaved in a single response. If the value is false, all the
matched log events in the first log stream are searched first, then
those in the next log stream, and so on. The default is false.

\strong{Important:} Starting on June 17, 2019, this parameter is ignored and
the value is assumed to be true. The response from this operation always
interleaves events from multiple log streams within a log group.}
}
\value{
A list with the following syntax:\preformatted{list(
  events = list(
    list(
      logStreamName = "string",
      timestamp = 123,
      message = "string",
      ingestionTime = 123,
      eventId = "string"
    )
  ),
  searchedLogStreams = list(
    list(
      logStreamName = "string",
      searchedCompletely = TRUE|FALSE
    )
  ),
  nextToken = "string"
)
}
}
\description{
Lists log events from the specified log group. You can list all the log
events or filter the results using a filter pattern, a time range, and
the name of the log stream.

By default, this operation returns as many log events as can fit in 1 MB
(up to 10,000 log events) or all the events found within the time range
that you specify. If the results include a token, then there are more
log events available, and you can get additional results by specifying
the token in a subsequent call. This operation can return empty results
while there are more log events available through the token.

The returned log events are sorted by event timestamp, the timestamp
when the event was ingested by CloudWatch Logs, and the ID of the
\code{\link[=cloudwatchlogs_put_log_events]{put_log_events}} request.
}
\section{Request syntax}{
\preformatted{svc$filter_log_events(
  logGroupName = "string",
  logStreamNames = list(
    "string"
  ),
  logStreamNamePrefix = "string",
  startTime = 123,
  endTime = 123,
  filterPattern = "string",
  nextToken = "string",
  limit = 123,
  interleaved = TRUE|FALSE
)
}
}

\keyword{internal}
