% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_describe_raid_arrays}
\alias{opsworks_describe_raid_arrays}
\title{Describe an instance's RAID arrays}
\usage{
opsworks_describe_raid_arrays(InstanceId, StackId, RaidArrayIds)
}
\arguments{
\item{InstanceId}{The instance ID. If you use this parameter,
\code{\link[=opsworks_describe_raid_arrays]{describe_raid_arrays}} returns
descriptions of the RAID arrays associated with the specified instance.}

\item{StackId}{The stack ID.}

\item{RaidArrayIds}{An array of RAID array IDs. If you use this parameter,
\code{\link[=opsworks_describe_raid_arrays]{describe_raid_arrays}} returns
descriptions of the specified arrays. Otherwise, it returns a
description of every array.}
}
\value{
A list with the following syntax:\preformatted{list(
  RaidArrays = list(
    list(
      RaidArrayId = "string",
      InstanceId = "string",
      Name = "string",
      RaidLevel = 123,
      NumberOfDisks = 123,
      Size = 123,
      Device = "string",
      MountPoint = "string",
      AvailabilityZone = "string",
      CreatedAt = "string",
      StackId = "string",
      VolumeType = "string",
      Iops = 123
    )
  )
)
}
}
\description{
Describe an instance's RAID arrays.

This call accepts only one resource-identifying parameter.

\strong{Required Permissions}: To use this action, an IAM user must have a
Show, Deploy, or Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information about
user permissions, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$describe_raid_arrays(
  InstanceId = "string",
  StackId = "string",
  RaidArrayIds = list(
    "string"
  )
)
}
}

\keyword{internal}
