% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_describe_provisioning_artifact}
\alias{servicecatalog_describe_provisioning_artifact}
\title{Gets information about the specified provisioning artifact (also known
as a version) for the specified product}
\usage{
servicecatalog_describe_provisioning_artifact(AcceptLanguage,
  ProvisioningArtifactId, ProductId, ProvisioningArtifactName,
  ProductName, Verbose)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProvisioningArtifactId}{The identifier of the provisioning artifact.}

\item{ProductId}{The product identifier.}

\item{ProvisioningArtifactName}{The provisioning artifact name.}

\item{ProductName}{The product name.}

\item{Verbose}{Indicates whether a verbose level of detail is enabled.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProvisioningArtifactDetail = list(
    Id = "string",
    Name = "string",
    Description = "string",
    Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE_AMI"|"MARKETPLACE_CAR",
    CreatedTime = as.POSIXct(
      "2015-01-01"
    ),
    Active = TRUE|FALSE,
    Guidance = "DEFAULT"|"DEPRECATED"
  ),
  Info = list(
    "string"
  ),
  Status = "AVAILABLE"|"CREATING"|"FAILED"
)
}
}
\description{
Gets information about the specified provisioning artifact (also known
as a version) for the specified product.
}
\section{Request syntax}{
\preformatted{svc$describe_provisioning_artifact(
  AcceptLanguage = "string",
  ProvisioningArtifactId = "string",
  ProductId = "string",
  ProvisioningArtifactName = "string",
  ProductName = "string",
  Verbose = TRUE|FALSE
)
}
}

\keyword{internal}
