% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_put_rule}
\alias{cloudwatchevents_put_rule}
\title{Creates or updates the specified rule}
\usage{
cloudwatchevents_put_rule(Name, ScheduleExpression, EventPattern, State,
  Description, RoleArn, Tags, EventBusName)
}
\arguments{
\item{Name}{[required] The name of the rule that you're creating or updating.}

\item{ScheduleExpression}{The scheduling expression: for example, \code{"cron(0 20 * * ? *)"} or
\code{"rate(5 minutes)"}.}

\item{EventPattern}{The event pattern. For more information, see \href{https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html}{Event Patterns}
in the \emph{Amazon EventBridge User Guide}.}

\item{State}{Indicates whether the rule is enabled or disabled.}

\item{Description}{A description of the rule.}

\item{RoleArn}{The Amazon Resource Name (ARN) of the IAM role associated with the rule.}

\item{Tags}{The list of key-value pairs to associate with the rule.}

\item{EventBusName}{The event bus to associate with this rule. If you omit this, the default
event bus is used.}
}
\description{
Creates or updates the specified rule. Rules are enabled by default or
based on value of the state. You can disable a rule using DisableRule.
}
\details{
A single rule watches for events from a single event bus. Events
generated by AWS services go to your account's default event bus.
Events generated by SaaS partner services or applications go to the
matching partner event bus. If you have custom applications or services,
you can specify whether their events go to your default event bus or a
custom event bus that you have created. For more information, see
CreateEventBus.

If you're updating an existing rule, the rule is replaced with what you
specify in this \code{PutRule} command. If you omit arguments in \code{PutRule},
the old values for those arguments aren't kept. Instead, they're
replaced with null values.

When you create or update a rule, incoming events might not immediately
start matching to new or updated rules. Allow a short period of time for
changes to take effect.

A rule must contain at least an \code{EventPattern} or \code{ScheduleExpression}.
Rules with \code{EventPatterns} are triggered when a matching event is
observed. Rules with \code{ScheduleExpressions} self-trigger based on the
given schedule. A rule can have both an \code{EventPattern} and a
\code{ScheduleExpression}, in which case the rule triggers on matching events
as well as on a schedule.

When you initially create a rule, you can optionally assign one or more
tags to the rule. Tags can help you organize and categorize your
resources. You can also use them to scope user permissions, by granting
a user permission to access or change only rules with certain tag
values. To use the \code{PutRule} operation and assign tags, you must have
both the \code{events:PutRule} and \code{events:TagResource} permissions.

If you are updating an existing rule, any tags you specify in the
\code{PutRule} operation are ignored. To update the tags of an existing rule,
use TagResource and UntagResource.

Most services in AWS treat \code{:} or \code{/} as the same character in Amazon
Resource Names (ARNs). However, EventBridge uses an exact match in event
patterns and rules. Be sure to use the correct ARN characters when
creating event patterns so that they match the ARN syntax in the event
that you want to match.

In EventBridge, you could create rules that lead to infinite loops,
where a rule is fired repeatedly. For example, a rule might detect that
ACLs have changed on an S3 bucket, and trigger software to change them
to the desired state. If you don't write the rule carefully, the
subsequent change to the ACLs fires the rule again, creating an infinite
loop.

To prevent this, write the rules so that the triggered actions don't
refire the same rule. For example, your rule could fire only if ACLs are
found to be in a bad state, instead of after any change.

An infinite loop can quickly cause higher than expected charges. We
recommend that you use budgeting, which alerts you when charges exceed
your specified limit. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html}{Managing Your Costs with Budgets}.
}
\section{Request syntax}{
\preformatted{svc$put_rule(
  Name = "string",
  ScheduleExpression = "string",
  EventPattern = "string",
  State = "ENABLED"|"DISABLED",
  Description = "string",
  RoleArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  EventBusName = "string"
)
}
}

\keyword{internal}
