% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_list_documents}
\alias{ssm_list_documents}
\title{Describes one or more of your Systems Manager documents}
\usage{
ssm_list_documents(DocumentFilterList, Filters, MaxResults, NextToken)
}
\arguments{
\item{DocumentFilterList}{One or more filters. Use a filter to return a more specific list of
results.}

\item{Filters}{One or more filters. Use a filter to return a more specific list of
results.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}
}
\description{
Describes one or more of your Systems Manager documents.
}
\section{Request syntax}{
\preformatted{svc$list_documents(
  DocumentFilterList = list(
    list(
      key = "Name"|"Owner"|"PlatformTypes"|"DocumentType",
      value = "string"
    )
  ),
  Filters = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
