% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_create_license_configuration}
\alias{licensemanager_create_license_configuration}
\title{Creates a new license configuration object}
\usage{
licensemanager_create_license_configuration(Name, Description,
  LicenseCountingType, LicenseCount, LicenseCountHardLimit, LicenseRules,
  Tags)
}
\arguments{
\item{Name}{[required] Name of the license configuration.}

\item{Description}{Human-friendly description of the license configuration.}

\item{LicenseCountingType}{[required] Dimension to use to track the license inventory.}

\item{LicenseCount}{Number of licenses managed by the license configuration.}

\item{LicenseCountHardLimit}{Flag indicating whether hard or soft license enforcement is used.
Exceeding a hard limit results in the blocked deployment of new
instances.}

\item{LicenseRules}{Array of configured License Manager rules.}

\item{Tags}{The tags to apply to the resources during launch. You can only tag
instances and volumes on launch. The specified tags are applied to all
instances or volumes that are created during launch. To tag a resource
after it has been created, see CreateTags .}
}
\description{
Creates a new license configuration object. A license configuration is
an abstraction of a customer license agreement that can be consumed and
enforced by License Manager. Components include specifications for the
license type (licensing by instance, socket, CPU, or VCPU), tenancy
(shared tenancy, Amazon EC2 Dedicated Instance, Amazon EC2 Dedicated
Host, or any of these), host affinity (how long a VM must be associated
with a host), the number of licenses purchased and used.
}
\section{Request syntax}{
\preformatted{svc$create_license_configuration(
  Name = "string",
  Description = "string",
  LicenseCountingType = "vCPU"|"Instance"|"Core"|"Socket",
  LicenseCount = 123,
  LicenseCountHardLimit = TRUE|FALSE,
  LicenseRules = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
