# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include resourcegroups_service.R
NULL

#' Creates a group with a specified name, description, and resource query
#'
#' Creates a group with a specified name, description, and resource query.
#'
#' @usage
#' resourcegroups_create_group(Name, Description, ResourceQuery, Tags)
#'
#' @param Name &#91;required&#93; The name of the group, which is the identifier of the group in other
#' operations. A resource group name cannot be updated after it is created.
#' A resource group name can have a maximum of 128 characters, including
#' letters, numbers, hyphens, dots, and underscores. The name cannot start
#' with `AWS` or `aws`; these are reserved. A resource group name must be
#' unique within your account.
#' @param Description The description of the resource group. Descriptions can have a maximum
#' of 511 characters, including letters, numbers, hyphens, underscores,
#' punctuation, and spaces.
#' @param ResourceQuery &#91;required&#93; The resource query that determines which AWS resources are members of
#' this group.
#' @param Tags The tags to add to the group. A tag is a string-to-string map of
#' key-value pairs. Tag keys can have a maximum character length of 128
#' characters, and tag values can have a maximum length of 256 characters.
#'
#' @section Request syntax:
#' ```
#' svc$create_group(
#'   Name = "string",
#'   Description = "string",
#'   ResourceQuery = list(
#'     Type = "TAG_FILTERS_1_0"|"CLOUDFORMATION_STACK_1_0",
#'     Query = "string"
#'   ),
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroups_create_group
resourcegroups_create_group <- function(Name, Description = NULL, ResourceQuery, Tags = NULL) {
  op <- new_operation(
    name = "CreateGroup",
    http_method = "POST",
    http_path = "/groups",
    paginator = list()
  )
  input <- .resourcegroups$create_group_input(Name = Name, Description = Description, ResourceQuery = ResourceQuery, Tags = Tags)
  output <- .resourcegroups$create_group_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$create_group <- resourcegroups_create_group

#' Deletes a specified resource group
#'
#' Deletes a specified resource group. Deleting a resource group does not
#' delete resources that are members of the group; it only deletes the
#' group structure.
#'
#' @usage
#' resourcegroups_delete_group(GroupName)
#'
#' @param GroupName &#91;required&#93; The name of the resource group to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_group(
#'   GroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroups_delete_group
resourcegroups_delete_group <- function(GroupName) {
  op <- new_operation(
    name = "DeleteGroup",
    http_method = "DELETE",
    http_path = "/groups/{GroupName}",
    paginator = list()
  )
  input <- .resourcegroups$delete_group_input(GroupName = GroupName)
  output <- .resourcegroups$delete_group_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$delete_group <- resourcegroups_delete_group

#' Returns information about a specified resource group
#'
#' Returns information about a specified resource group.
#'
#' @usage
#' resourcegroups_get_group(GroupName)
#'
#' @param GroupName &#91;required&#93; The name of the resource group.
#'
#' @section Request syntax:
#' ```
#' svc$get_group(
#'   GroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroups_get_group
resourcegroups_get_group <- function(GroupName) {
  op <- new_operation(
    name = "GetGroup",
    http_method = "GET",
    http_path = "/groups/{GroupName}",
    paginator = list()
  )
  input <- .resourcegroups$get_group_input(GroupName = GroupName)
  output <- .resourcegroups$get_group_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$get_group <- resourcegroups_get_group

#' Returns the resource query associated with the specified resource group
#'
#' Returns the resource query associated with the specified resource group.
#'
#' @usage
#' resourcegroups_get_group_query(GroupName)
#'
#' @param GroupName &#91;required&#93; The name of the resource group.
#'
#' @section Request syntax:
#' ```
#' svc$get_group_query(
#'   GroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroups_get_group_query
resourcegroups_get_group_query <- function(GroupName) {
  op <- new_operation(
    name = "GetGroupQuery",
    http_method = "GET",
    http_path = "/groups/{GroupName}/query",
    paginator = list()
  )
  input <- .resourcegroups$get_group_query_input(GroupName = GroupName)
  output <- .resourcegroups$get_group_query_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$get_group_query <- resourcegroups_get_group_query

#' Returns a list of tags that are associated with a resource group,
#' specified by an ARN
#'
#' Returns a list of tags that are associated with a resource group,
#' specified by an ARN.
#'
#' @usage
#' resourcegroups_get_tags(Arn)
#'
#' @param Arn &#91;required&#93; The ARN of the resource group for which you want a list of tags. The
#' resource must exist within the account you are using.
#'
#' @section Request syntax:
#' ```
#' svc$get_tags(
#'   Arn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroups_get_tags
resourcegroups_get_tags <- function(Arn) {
  op <- new_operation(
    name = "GetTags",
    http_method = "GET",
    http_path = "/resources/{Arn}/tags",
    paginator = list()
  )
  input <- .resourcegroups$get_tags_input(Arn = Arn)
  output <- .resourcegroups$get_tags_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$get_tags <- resourcegroups_get_tags

#' Returns a list of ARNs of resources that are members of a specified
#' resource group
#'
#' Returns a list of ARNs of resources that are members of a specified
#' resource group.
#'
#' @usage
#' resourcegroups_list_group_resources(GroupName, Filters, MaxResults,
#'   NextToken)
#'
#' @param GroupName &#91;required&#93; The name of the resource group.
#' @param Filters Filters, formatted as ResourceFilter objects, that you want to apply to
#' a ListGroupResources operation.
#' 
#' -   `resource-type` - Filter resources by their type. Specify up to five
#'     resource types in the format AWS::ServiceCode::ResourceType. For
#'     example, AWS::EC2::Instance, or AWS::S3::Bucket.
#' @param MaxResults The maximum number of group member ARNs that are returned in a single
#' call by ListGroupResources, in paginated output. By default, this number
#' is 50.
#' @param NextToken The NextToken value that is returned in a paginated ListGroupResources
#' request. To get the next page of results, run the call again, add the
#' NextToken parameter, and specify the NextToken value.
#'
#' @section Request syntax:
#' ```
#' svc$list_group_resources(
#'   GroupName = "string",
#'   Filters = list(
#'     list(
#'       Name = "resource-type",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroups_list_group_resources
resourcegroups_list_group_resources <- function(GroupName, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListGroupResources",
    http_method = "POST",
    http_path = "/groups/{GroupName}/resource-identifiers-list",
    paginator = list()
  )
  input <- .resourcegroups$list_group_resources_input(GroupName = GroupName, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .resourcegroups$list_group_resources_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$list_group_resources <- resourcegroups_list_group_resources

#' Returns a list of existing resource groups in your account
#'
#' Returns a list of existing resource groups in your account.
#'
#' @usage
#' resourcegroups_list_groups(Filters, MaxResults, NextToken)
#'
#' @param Filters Filters, formatted as GroupFilter objects, that you want to apply to a
#' ListGroups operation.
#' 
#' -   `resource-type` - Filter groups by resource type. Specify up to five
#'     resource types in the format AWS::ServiceCode::ResourceType. For
#'     example, AWS::EC2::Instance, or AWS::S3::Bucket.
#' @param MaxResults The maximum number of resource group results that are returned by
#' ListGroups in paginated output. By default, this number is 50.
#' @param NextToken The NextToken value that is returned in a paginated `ListGroups`
#' request. To get the next page of results, run the call again, add the
#' NextToken parameter, and specify the NextToken value.
#'
#' @section Request syntax:
#' ```
#' svc$list_groups(
#'   Filters = list(
#'     list(
#'       Name = "resource-type",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroups_list_groups
resourcegroups_list_groups <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListGroups",
    http_method = "POST",
    http_path = "/groups-list",
    paginator = list()
  )
  input <- .resourcegroups$list_groups_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .resourcegroups$list_groups_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$list_groups <- resourcegroups_list_groups

#' Returns a list of AWS resource identifiers that matches a specified
#' query
#'
#' Returns a list of AWS resource identifiers that matches a specified
#' query. The query uses the same format as a resource query in a
#' CreateGroup or UpdateGroupQuery operation.
#'
#' @usage
#' resourcegroups_search_resources(ResourceQuery, MaxResults, NextToken)
#'
#' @param ResourceQuery &#91;required&#93; The search query, using the same formats that are supported for resource
#' group definition.
#' @param MaxResults The maximum number of group member ARNs returned by `SearchResources` in
#' paginated output. By default, this number is 50.
#' @param NextToken The NextToken value that is returned in a paginated `SearchResources`
#' request. To get the next page of results, run the call again, add the
#' NextToken parameter, and specify the NextToken value.
#'
#' @section Request syntax:
#' ```
#' svc$search_resources(
#'   ResourceQuery = list(
#'     Type = "TAG_FILTERS_1_0"|"CLOUDFORMATION_STACK_1_0",
#'     Query = "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroups_search_resources
resourcegroups_search_resources <- function(ResourceQuery, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "SearchResources",
    http_method = "POST",
    http_path = "/resources/search",
    paginator = list()
  )
  input <- .resourcegroups$search_resources_input(ResourceQuery = ResourceQuery, MaxResults = MaxResults, NextToken = NextToken)
  output <- .resourcegroups$search_resources_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$search_resources <- resourcegroups_search_resources

#' Adds tags to a resource group with the specified ARN
#'
#' Adds tags to a resource group with the specified ARN. Existing tags on a
#' resource group are not changed if they are not specified in the request
#' parameters.
#'
#' @usage
#' resourcegroups_tag(Arn, Tags)
#'
#' @param Arn &#91;required&#93; The ARN of the resource to which to add tags.
#' @param Tags &#91;required&#93; The tags to add to the specified resource. A tag is a string-to-string
#' map of key-value pairs. Tag keys can have a maximum character length of
#' 128 characters, and tag values can have a maximum length of 256
#' characters.
#'
#' @section Request syntax:
#' ```
#' svc$tag(
#'   Arn = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroups_tag
resourcegroups_tag <- function(Arn, Tags) {
  op <- new_operation(
    name = "Tag",
    http_method = "PUT",
    http_path = "/resources/{Arn}/tags",
    paginator = list()
  )
  input <- .resourcegroups$tag_input(Arn = Arn, Tags = Tags)
  output <- .resourcegroups$tag_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$tag <- resourcegroups_tag

#' Deletes specified tags from a specified resource
#'
#' Deletes specified tags from a specified resource.
#'
#' @usage
#' resourcegroups_untag(Arn, Keys)
#'
#' @param Arn &#91;required&#93; The ARN of the resource from which to remove tags.
#' @param Keys &#91;required&#93; The keys of the tags to be removed.
#'
#' @section Request syntax:
#' ```
#' svc$untag(
#'   Arn = "string",
#'   Keys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroups_untag
resourcegroups_untag <- function(Arn, Keys) {
  op <- new_operation(
    name = "Untag",
    http_method = "PATCH",
    http_path = "/resources/{Arn}/tags",
    paginator = list()
  )
  input <- .resourcegroups$untag_input(Arn = Arn, Keys = Keys)
  output <- .resourcegroups$untag_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$untag <- resourcegroups_untag

#' Updates an existing group with a new or changed description
#'
#' Updates an existing group with a new or changed description. You cannot
#' update the name of a resource group.
#'
#' @usage
#' resourcegroups_update_group(GroupName, Description)
#'
#' @param GroupName &#91;required&#93; The name of the resource group for which you want to update its
#' description.
#' @param Description The description of the resource group. Descriptions can have a maximum
#' of 511 characters, including letters, numbers, hyphens, underscores,
#' punctuation, and spaces.
#'
#' @section Request syntax:
#' ```
#' svc$update_group(
#'   GroupName = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroups_update_group
resourcegroups_update_group <- function(GroupName, Description = NULL) {
  op <- new_operation(
    name = "UpdateGroup",
    http_method = "PUT",
    http_path = "/groups/{GroupName}",
    paginator = list()
  )
  input <- .resourcegroups$update_group_input(GroupName = GroupName, Description = Description)
  output <- .resourcegroups$update_group_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$update_group <- resourcegroups_update_group

#' Updates the resource query of a group
#'
#' Updates the resource query of a group.
#'
#' @usage
#' resourcegroups_update_group_query(GroupName, ResourceQuery)
#'
#' @param GroupName &#91;required&#93; The name of the resource group for which you want to edit the query.
#' @param ResourceQuery &#91;required&#93; The resource query that determines which AWS resources are members of
#' the resource group.
#'
#' @section Request syntax:
#' ```
#' svc$update_group_query(
#'   GroupName = "string",
#'   ResourceQuery = list(
#'     Type = "TAG_FILTERS_1_0"|"CLOUDFORMATION_STACK_1_0",
#'     Query = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname resourcegroups_update_group_query
resourcegroups_update_group_query <- function(GroupName, ResourceQuery) {
  op <- new_operation(
    name = "UpdateGroupQuery",
    http_method = "PUT",
    http_path = "/groups/{GroupName}/query",
    paginator = list()
  )
  input <- .resourcegroups$update_group_query_input(GroupName = GroupName, ResourceQuery = ResourceQuery)
  output <- .resourcegroups$update_group_query_output()
  config <- get_config()
  svc <- .resourcegroups$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourcegroups$operations$update_group_query <- resourcegroups_update_group_query
