% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_describe_volumes}
\alias{opsworks_describe_volumes}
\title{Describes an instance's Amazon EBS volumes}
\usage{
opsworks_describe_volumes(InstanceId, StackId, RaidArrayId, VolumeIds)
}
\arguments{
\item{InstanceId}{The instance ID. If you use this parameter, \code{DescribeVolumes} returns
descriptions of the volumes associated with the specified instance.}

\item{StackId}{A stack ID. The action describes the stack\'s registered Amazon EBS
volumes.}

\item{RaidArrayId}{The RAID array ID. If you use this parameter, \code{DescribeVolumes} returns
descriptions of the volumes associated with the specified RAID array.}

\item{VolumeIds}{Am array of volume IDs. If you use this parameter, \code{DescribeVolumes}
returns descriptions of the specified volumes. Otherwise, it returns a
description of every volume.}
}
\description{
Describes an instance\'s Amazon EBS volumes.
}
\details{
This call accepts only one resource-identifying parameter.

\strong{Required Permissions}: To use this action, an IAM user must have a
Show, Deploy, or Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information about
user permissions, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$describe_volumes(
  InstanceId = "string",
  StackId = "string",
  RaidArrayId = "string",
  VolumeIds = list(
    "string"
  )
)
}
}

\keyword{internal}
