% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroups_operations.R
\name{resourcegroups_list_group_resources}
\alias{resourcegroups_list_group_resources}
\title{Returns a list of ARNs of resources that are members of a specified
resource group}
\usage{
resourcegroups_list_group_resources(GroupName, Filters, MaxResults,
  NextToken)
}
\arguments{
\item{GroupName}{[required] The name of the resource group.}

\item{Filters}{Filters, formatted as ResourceFilter objects, that you want to apply to
a ListGroupResources operation.
\itemize{
\item \code{resource-type} - Filter resources by their type. Specify up to five
resource types in the format AWS::ServiceCode::ResourceType. For
example, AWS::EC2::Instance, or AWS::S3::Bucket.
}}

\item{MaxResults}{The maximum number of group member ARNs that are returned in a single
call by ListGroupResources, in paginated output. By default, this number
is 50.}

\item{NextToken}{The NextToken value that is returned in a paginated ListGroupResources
request. To get the next page of results, run the call again, add the
NextToken parameter, and specify the NextToken value.}
}
\description{
Returns a list of ARNs of resources that are members of a specified
resource group.
}
\section{Request syntax}{
\preformatted{svc$list_group_resources(
  GroupName = "string",
  Filters = list(
    list(
      Name = "resource-type",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
