% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_list_accounts_for_parent}
\alias{organizations_list_accounts_for_parent}
\title{Lists the accounts in an organization that are contained by the
specified target root or organizational unit (OU)}
\usage{
organizations_list_accounts_for_parent(ParentId, NextToken, MaxResults)
}
\arguments{
\item{ParentId}{[required] The unique identifier (ID) for the parent root or organization unit (OU)
whose accounts you want to list.}

\item{NextToken}{Use this parameter if you receive a \code{NextToken} response in a previous
request that indicates that there is more output available. Set it to
the value of the previous call\'s \code{NextToken} response to indicate where
the output should continue from.}

\item{MaxResults}{(Optional) Use this to limit the number of results you want included per
page in the response. If you do not include this parameter, it defaults
to a value that is specific to the operation. If additional items exist
beyond the maximum you specify, the \code{NextToken} response element is
present and has a value (is not null). Include that value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results. Note that Organizations might return fewer
results than the maximum even when there are more results available. You
should check \code{NextToken} after every operation to ensure that you
receive all of the results.}
}
\description{
Lists the accounts in an organization that are contained by the
specified target root or organizational unit (OU). If you specify the
root, you get a list of all the accounts that aren\'t in any OU. If you
specify an OU, you get a list of all the accounts in only that OU and
not in any child OUs. To get a list of all accounts in the organization,
use the ListAccounts operation.
}
\details{
Always check the \code{NextToken} response parameter for a \code{null} value when
calling a \verb{List*} operation. These operations can occasionally return an
empty set of results even when there are more results available. The
\code{NextToken} response parameter value is \code{null} \emph{only} when there are no
more results to display.

This operation can be called only from the organization\'s master
account.
}
\section{Request syntax}{
\preformatted{svc$list_accounts_for_parent(
  ParentId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
\dontrun{
# The following example shows how to request a list of the accounts in an
# OU:/n/n
svc$list_accounts_for_parent(
  ParentId = "ou-examplerootid111-exampleouid111"
)
}

}
\keyword{internal}
