% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_deregister_delegated_administrator}
\alias{organizations_deregister_delegated_administrator}
\title{Removes the specified member AWS account as a delegated administrator
for the specified AWS service}
\usage{
organizations_deregister_delegated_administrator(AccountId,
  ServicePrincipal)
}
\arguments{
\item{AccountId}{[required] The account ID number of the member account in the organization that you
want to deregister as a delegated administrator.}

\item{ServicePrincipal}{[required] The service principal name of an AWS service for which the account is a
delegated administrator.

Delegated administrator privileges are revoked for only the specified
AWS service from the member account. If the specified service is the
only service for which the member account is a delegated administrator,
the operation also revokes Organizations read action permissions.}
}
\description{
Removes the specified member AWS account as a delegated administrator
for the specified AWS service.
}
\details{
You can run this action only for AWS services that support this feature.
For a current list of services that support it, see the column \emph{Supports
Delegated Administrator} in the table at \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrated-services-list.html}{AWS Services that you can use with AWS Organizations}
in the \emph{AWS Organizations User Guide.}

This operation can be called only from the organization\'s master
account.
}
\section{Request syntax}{
\preformatted{svc$deregister_delegated_administrator(
  AccountId = "string",
  ServicePrincipal = "string"
)
}
}

\keyword{internal}
