% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_describe_handshake}
\alias{organizations_describe_handshake}
\title{Retrieves information about a previously requested handshake}
\usage{
organizations_describe_handshake(HandshakeId)
}
\arguments{
\item{HandshakeId}{[required] The unique identifier (ID) of the handshake that you want information
about. You can get the ID from the original call to
InviteAccountToOrganization, or from a call to ListHandshakesForAccount
or ListHandshakesForOrganization.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for handshake ID
string requires \"h-\" followed by from 8 to 32 lowercase letters or
digits.}
}
\description{
Retrieves information about a previously requested handshake. The
handshake ID comes from the response to the original
InviteAccountToOrganization operation that generated the handshake.
}
\details{
You can access handshakes that are \code{ACCEPTED}, \code{DECLINED}, or \code{CANCELED}
for only 30 days after they change to that state. They\'re then deleted
and no longer accessible.

This operation can be called from any account in the organization.
}
\section{Request syntax}{
\preformatted{svc$describe_handshake(
  HandshakeId = "string"
)
}
}

\examples{
\dontrun{
# The following example shows you how to request details about a
# handshake. The handshake ID comes either from the original call to
# "InviteAccountToOrganization", or from a call to
# "ListHandshakesForAccount" or "ListHandshakesForOrganization":
svc$describe_handshake(
  HandshakeId = "h-examplehandshakeid111"
)
}

}
\keyword{internal}
