% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_update_ops_item}
\alias{ssm_update_ops_item}
\title{Edit or change an OpsItem}
\usage{
ssm_update_ops_item(Description, OperationalData,
  OperationalDataToDelete, Notifications, Priority, RelatedOpsItems,
  Status, OpsItemId, Title, Category, Severity)
}
\arguments{
\item{Description}{Update the information about the OpsItem. Provide enough information so
that users reading this OpsItem for the first time understand the issue.}

\item{OperationalData}{Add new keys or edit existing key-value pairs of the OperationalData map
in the OpsItem object.

Operational data is custom data that provides useful reference details
about the OpsItem. For example, you can specify log files, error
strings, license keys, troubleshooting tips, or other relevant data. You
enter operational data as key-value pairs. The key has a maximum length
of 128 characters. The value has a maximum size of 20 KB.

Operational data keys \emph{can\'t} begin with the following: amazon, aws,
amzn, ssm, /amazon, /aws, /amzn, /ssm.

You can choose to make the data searchable by other users in the account
or you can restrict search access. Searchable data means that all users
with access to the OpsItem Overview page (as provided by the
DescribeOpsItems API action) can view and search on the specified data.
Operational data that is not searchable is only viewable by users who
have access to the OpsItem (as provided by the GetOpsItem API action).

Use the \verb{/aws/resources} key in OperationalData to specify a related
resource in the request. Use the \verb{/aws/automations} key in
OperationalData to associate an Automation runbook with the OpsItem. To
view AWS CLI example commands that use these keys, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems}{Creating OpsItems manually}
in the \emph{AWS Systems Manager User Guide}.}

\item{OperationalDataToDelete}{Keys that you want to remove from the OperationalData map.}

\item{Notifications}{The Amazon Resource Name (ARN) of an SNS topic where notifications are
sent when this OpsItem is edited or changed.}

\item{Priority}{The importance of this OpsItem in relation to other OpsItems in the
system.}

\item{RelatedOpsItems}{One or more OpsItems that share something in common with the current
OpsItems. For example, related OpsItems can include OpsItems with
similar error messages, impacted resources, or statuses for the impacted
resource.}

\item{Status}{The OpsItem status. Status can be \code{Open}, \verb{In Progress}, or \code{Resolved}.
For more information, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems.html#OpsCenter-working-with-OpsItems-editing-details}{Editing OpsItem details}
in the \emph{AWS Systems Manager User Guide}.}

\item{OpsItemId}{[required] The ID of the OpsItem.}

\item{Title}{A short heading that describes the nature of the OpsItem and the
impacted resource.}

\item{Category}{Specify a new category for an OpsItem.}

\item{Severity}{Specify a new severity for an OpsItem.}
}
\description{
Edit or change an OpsItem. You must have permission in AWS Identity and
Access Management (IAM) to update an OpsItem. For more information, see
\href{https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html}{Getting started with OpsCenter}
in the \emph{AWS Systems Manager User Guide}.
}
\details{
Operations engineers and IT professionals use OpsCenter to view,
investigate, and remediate operational issues impacting the performance
and health of their AWS resources. For more information, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html}{AWS Systems Manager OpsCenter}
in the \emph{AWS Systems Manager User Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_ops_item(
  Description = "string",
  OperationalData = list(
    list(
      Value = "string",
      Type = "SearchableString"|"String"
    )
  ),
  OperationalDataToDelete = list(
    "string"
  ),
  Notifications = list(
    list(
      Arn = "string"
    )
  ),
  Priority = 123,
  RelatedOpsItems = list(
    list(
      OpsItemId = "string"
    )
  ),
  Status = "Open"|"InProgress"|"Resolved",
  OpsItemId = "string",
  Title = "string",
  Category = "string",
  Severity = "string"
)
}
}

\keyword{internal}
