# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudtrail_service.R
NULL

#' Adds one or more tags to a trail or event data store, up to a limit of
#' 50
#'
#' @description
#' Adds one or more tags to a trail or event data store, up to a limit of 50. Overwrites an existing tag's value when a new value is specified for an existing tag key. Tag key names must be unique for a trail; you cannot have two keys with the same name but different values. If you specify a key without a value, the tag will be created with the specified key and a value of null. You can tag a trail or event data store that applies to all Amazon Web Services Regions only from the Region in which the trail or event data store was created (also known as its home region).
#'
#' See [https://paws-r.github.io/docs/cloudtrail/add_tags.html](https://paws-r.github.io/docs/cloudtrail/add_tags.html) for full documentation.
#'
#' @param ResourceId &#91;required&#93; Specifies the ARN of the trail or event data store to which one or more
#' tags will be added. The format of a trail ARN is:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' @param TagsList &#91;required&#93; Contains a list of tags, up to a limit of 50
#'
#' @keywords internal
#'
#' @rdname cloudtrail_add_tags
cloudtrail_add_tags <- function(ResourceId, TagsList) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$add_tags_input(ResourceId = ResourceId, TagsList = TagsList)
  output <- .cloudtrail$add_tags_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$add_tags <- cloudtrail_add_tags

#' Cancels a query if the query is not in a terminated state, such as
#' CANCELLED, FAILED, TIMED_OUT, or FINISHED
#'
#' @description
#' Cancels a query if the query is not in a terminated state, such as `CANCELLED`, `FAILED`, `TIMED_OUT`, or `FINISHED`. You must specify an ARN value for `EventDataStore`. The ID of the query that you want to cancel is also required. When you run [`cancel_query`][cloudtrail_cancel_query], the query status might show as `CANCELLED` even if the operation is not yet finished.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/cancel_query.html](https://paws-r.github.io/docs/cloudtrail/cancel_query.html) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or the ID suffix of the ARN) of an event data store on which
#' the specified query is running.
#' @param QueryId &#91;required&#93; The ID of the query that you want to cancel. The `QueryId` comes from
#' the response of a [`start_query`][cloudtrail_start_query] operation.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_cancel_query
cloudtrail_cancel_query <- function(EventDataStore, QueryId) {
  op <- new_operation(
    name = "CancelQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$cancel_query_input(EventDataStore = EventDataStore, QueryId = QueryId)
  output <- .cloudtrail$cancel_query_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$cancel_query <- cloudtrail_cancel_query

#' Creates a new event data store
#'
#' @description
#' Creates a new event data store.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/create_event_data_store.html](https://paws-r.github.io/docs/cloudtrail/create_event_data_store.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the event data store.
#' @param AdvancedEventSelectors The advanced event selectors to use to select the events for the data
#' store. For more information about how to use advanced event selectors,
#' see [Log events by using advanced event
#' selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced)
#' in the CloudTrail User Guide.
#' @param MultiRegionEnabled Specifies whether the event data store includes events from all regions,
#' or only from the region in which the event data store is created.
#' @param OrganizationEnabled Specifies whether an event data store collects events logged for an
#' organization in Organizations.
#' @param RetentionPeriod The retention period of the event data store, in days. You can set a
#' retention period of up to 2555 days, the equivalent of seven years.
#' @param TerminationProtectionEnabled Specifies whether termination protection is enabled for the event data
#' store. If termination protection is enabled, you cannot delete the event
#' data store until termination protection is disabled.
#' @param TagsList 
#'
#' @keywords internal
#'
#' @rdname cloudtrail_create_event_data_store
cloudtrail_create_event_data_store <- function(Name, AdvancedEventSelectors = NULL, MultiRegionEnabled = NULL, OrganizationEnabled = NULL, RetentionPeriod = NULL, TerminationProtectionEnabled = NULL, TagsList = NULL) {
  op <- new_operation(
    name = "CreateEventDataStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$create_event_data_store_input(Name = Name, AdvancedEventSelectors = AdvancedEventSelectors, MultiRegionEnabled = MultiRegionEnabled, OrganizationEnabled = OrganizationEnabled, RetentionPeriod = RetentionPeriod, TerminationProtectionEnabled = TerminationProtectionEnabled, TagsList = TagsList)
  output <- .cloudtrail$create_event_data_store_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$create_event_data_store <- cloudtrail_create_event_data_store

#' Creates a trail that specifies the settings for delivery of log data to
#' an Amazon S3 bucket
#'
#' @description
#' Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/create_trail.html](https://paws-r.github.io/docs/cloudtrail/create_trail.html) for full documentation.
#'
#' @param Name &#91;required&#93; Specifies the name of the trail. The name must meet the following
#' requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are not valid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' @param S3BucketName &#91;required&#93; Specifies the name of the Amazon S3 bucket designated for publishing log
#' files. See [Amazon S3 Bucket Naming
#' Requirements](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-s3-bucket-naming-requirements.html).
#' @param S3KeyPrefix Specifies the Amazon S3 key prefix that comes after the name of the
#' bucket you have designated for log file delivery. For more information,
#' see [Finding Your CloudTrail Log
#' Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
#' The maximum length is 200 characters.
#' @param SnsTopicName Specifies the name of the Amazon SNS topic defined for notification of
#' log file delivery. The maximum length is 256 characters.
#' @param IncludeGlobalServiceEvents Specifies whether the trail is publishing events from global services
#' such as IAM to the log files.
#' @param IsMultiRegionTrail Specifies whether the trail is created in the current region or in all
#' regions. The default is false, which creates a trail only in the region
#' where you are signed in. As a best practice, consider creating trails
#' that log events in all regions.
#' @param EnableLogFileValidation Specifies whether log file integrity validation is enabled. The default
#' is false.
#' 
#' When you disable log file integrity validation, the chain of digest
#' files is broken after one hour. CloudTrail does not create digest files
#' for log files that were delivered during a period in which log file
#' integrity validation was disabled. For example, if you enable log file
#' integrity validation at noon on January 1, disable it at noon on January
#' 2, and re-enable it at noon on January 10, digest files will not be
#' created for the log files delivered from noon on January 2 to noon on
#' January 10. The same applies whenever you stop CloudTrail logging or
#' delete a trail.
#' @param CloudWatchLogsLogGroupArn Specifies a log group name using an Amazon Resource Name (ARN), a unique
#' identifier that represents the log group to which CloudTrail logs will
#' be delivered. Not required unless you specify `CloudWatchLogsRoleArn`.
#' @param CloudWatchLogsRoleArn Specifies the role for the CloudWatch Logs endpoint to assume to write
#' to a user's log group.
#' @param KmsKeyId Specifies the KMS key ID to use to encrypt the logs delivered by
#' CloudTrail. The value can be an alias name prefixed by "alias/", a fully
#' specified ARN to an alias, a fully specified ARN to a key, or a globally
#' unique identifier.
#' 
#' CloudTrail also supports KMS multi-Region keys. For more information
#' about multi-Region keys, see [Using multi-Region
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
#' in the *Key Management Service Developer Guide*.
#' 
#' Examples:
#' 
#' -   alias/MyAliasName
#' 
#' -   arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
#' 
#' -   arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
#' 
#' -   12345678-1234-1234-1234-123456789012
#' @param IsOrganizationTrail Specifies whether the trail is created for all accounts in an
#' organization in Organizations, or only for the current Amazon Web
#' Services account. The default is false, and cannot be true unless the
#' call is made on behalf of an Amazon Web Services account that is the
#' management account for an organization in Organizations.
#' @param TagsList 
#'
#' @keywords internal
#'
#' @rdname cloudtrail_create_trail
cloudtrail_create_trail <- function(Name, S3BucketName, S3KeyPrefix = NULL, SnsTopicName = NULL, IncludeGlobalServiceEvents = NULL, IsMultiRegionTrail = NULL, EnableLogFileValidation = NULL, CloudWatchLogsLogGroupArn = NULL, CloudWatchLogsRoleArn = NULL, KmsKeyId = NULL, IsOrganizationTrail = NULL, TagsList = NULL) {
  op <- new_operation(
    name = "CreateTrail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$create_trail_input(Name = Name, S3BucketName = S3BucketName, S3KeyPrefix = S3KeyPrefix, SnsTopicName = SnsTopicName, IncludeGlobalServiceEvents = IncludeGlobalServiceEvents, IsMultiRegionTrail = IsMultiRegionTrail, EnableLogFileValidation = EnableLogFileValidation, CloudWatchLogsLogGroupArn = CloudWatchLogsLogGroupArn, CloudWatchLogsRoleArn = CloudWatchLogsRoleArn, KmsKeyId = KmsKeyId, IsOrganizationTrail = IsOrganizationTrail, TagsList = TagsList)
  output <- .cloudtrail$create_trail_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$create_trail <- cloudtrail_create_trail

#' Disables the event data store specified by EventDataStore, which accepts
#' an event data store ARN
#'
#' @description
#' Disables the event data store specified by `EventDataStore`, which accepts an event data store ARN. After you run [`delete_event_data_store`][cloudtrail_delete_event_data_store], the event data store enters a `PENDING_DELETION` state, and is automatically deleted after a wait period of seven days. `TerminationProtectionEnabled` must be set to `False` on the event data store; this operation cannot work if `TerminationProtectionEnabled` is `True`.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/delete_event_data_store.html](https://paws-r.github.io/docs/cloudtrail/delete_event_data_store.html) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or the ID suffix of the ARN) of the event data store to delete.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_delete_event_data_store
cloudtrail_delete_event_data_store <- function(EventDataStore) {
  op <- new_operation(
    name = "DeleteEventDataStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$delete_event_data_store_input(EventDataStore = EventDataStore)
  output <- .cloudtrail$delete_event_data_store_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$delete_event_data_store <- cloudtrail_delete_event_data_store

#' Deletes a trail
#'
#' @description
#' Deletes a trail. This operation must be called from the region in which the trail was created. [`delete_trail`][cloudtrail_delete_trail] cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled in all regions.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/delete_trail.html](https://paws-r.github.io/docs/cloudtrail/delete_trail.html) for full documentation.
#'
#' @param Name &#91;required&#93; Specifies the name or the CloudTrail ARN of the trail to be deleted. The
#' following is the format of a trail ARN.
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @keywords internal
#'
#' @rdname cloudtrail_delete_trail
cloudtrail_delete_trail <- function(Name) {
  op <- new_operation(
    name = "DeleteTrail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$delete_trail_input(Name = Name)
  output <- .cloudtrail$delete_trail_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$delete_trail <- cloudtrail_delete_trail

#' Returns metadata about a query, including query run time in
#' milliseconds, number of events scanned and matched, and query status
#'
#' @description
#' Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched, and query status. You must specify an ARN for `EventDataStore`, and a value for `QueryID`.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/describe_query.html](https://paws-r.github.io/docs/cloudtrail/describe_query.html) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or the ID suffix of the ARN) of an event data store on which
#' the specified query was run.
#' @param QueryId &#91;required&#93; The query ID.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_describe_query
cloudtrail_describe_query <- function(EventDataStore, QueryId) {
  op <- new_operation(
    name = "DescribeQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$describe_query_input(EventDataStore = EventDataStore, QueryId = QueryId)
  output <- .cloudtrail$describe_query_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$describe_query <- cloudtrail_describe_query

#' Retrieves settings for one or more trails associated with the current
#' region for your account
#'
#' @description
#' Retrieves settings for one or more trails associated with the current region for your account.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/describe_trails.html](https://paws-r.github.io/docs/cloudtrail/describe_trails.html) for full documentation.
#'
#' @param trailNameList Specifies a list of trail names, trail ARNs, or both, of the trails to
#' describe. The format of a trail ARN is:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' 
#' If an empty list is specified, information for the trail in the current
#' region is returned.
#' 
#' -   If an empty list is specified and `IncludeShadowTrails` is false,
#'     then information for all trails in the current region is returned.
#' 
#' -   If an empty list is specified and IncludeShadowTrails is null or
#'     true, then information for all trails in the current region and any
#'     associated shadow trails in other regions is returned.
#' 
#' If one or more trail names are specified, information is returned only
#' if the names match the names of trails belonging only to the current
#' region. To return information about a trail in another region, you must
#' specify its trail ARN.
#' @param includeShadowTrails Specifies whether to include shadow trails in the response. A shadow
#' trail is the replication in a region of a trail that was created in a
#' different region, or in the case of an organization trail, the
#' replication of an organization trail in member accounts. If you do not
#' include shadow trails, organization trails in a member account and
#' region replication trails will not be returned. The default is true.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_describe_trails
cloudtrail_describe_trails <- function(trailNameList = NULL, includeShadowTrails = NULL) {
  op <- new_operation(
    name = "DescribeTrails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$describe_trails_input(trailNameList = trailNameList, includeShadowTrails = includeShadowTrails)
  output <- .cloudtrail$describe_trails_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$describe_trails <- cloudtrail_describe_trails

#' Returns information about an event data store specified as either an ARN
#' or the ID portion of the ARN
#'
#' @description
#' Returns information about an event data store specified as either an ARN or the ID portion of the ARN.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/get_event_data_store.html](https://paws-r.github.io/docs/cloudtrail/get_event_data_store.html) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or ID suffix of the ARN) of the event data store about which
#' you want information.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_event_data_store
cloudtrail_get_event_data_store <- function(EventDataStore) {
  op <- new_operation(
    name = "GetEventDataStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$get_event_data_store_input(EventDataStore = EventDataStore)
  output <- .cloudtrail$get_event_data_store_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_event_data_store <- cloudtrail_get_event_data_store

#' Describes the settings for the event selectors that you configured for
#' your trail
#'
#' @description
#' Describes the settings for the event selectors that you configured for your trail. The information returned for your event selectors includes the following:
#'
#' See [https://paws-r.github.io/docs/cloudtrail/get_event_selectors.html](https://paws-r.github.io/docs/cloudtrail/get_event_selectors.html) for full documentation.
#'
#' @param TrailName &#91;required&#93; Specifies the name of the trail or trail ARN. If you specify a trail
#' name, the string must meet the following requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are not valid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' 
#' If you specify a trail ARN, it must be in the format:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_event_selectors
cloudtrail_get_event_selectors <- function(TrailName) {
  op <- new_operation(
    name = "GetEventSelectors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$get_event_selectors_input(TrailName = TrailName)
  output <- .cloudtrail$get_event_selectors_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_event_selectors <- cloudtrail_get_event_selectors

#' Describes the settings for the Insights event selectors that you
#' configured for your trail
#'
#' @description
#' Describes the settings for the Insights event selectors that you configured for your trail. [`get_insight_selectors`][cloudtrail_get_insight_selectors] shows if CloudTrail Insights event logging is enabled on the trail, and if it is, which insight types are enabled. If you run [`get_insight_selectors`][cloudtrail_get_insight_selectors] on a trail that does not have Insights events enabled, the operation throws the exception `InsightNotEnabledException`
#'
#' See [https://paws-r.github.io/docs/cloudtrail/get_insight_selectors.html](https://paws-r.github.io/docs/cloudtrail/get_insight_selectors.html) for full documentation.
#'
#' @param TrailName &#91;required&#93; Specifies the name of the trail or trail ARN. If you specify a trail
#' name, the string must meet the following requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are not valid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' 
#' If you specify a trail ARN, it must be in the format:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_insight_selectors
cloudtrail_get_insight_selectors <- function(TrailName) {
  op <- new_operation(
    name = "GetInsightSelectors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$get_insight_selectors_input(TrailName = TrailName)
  output <- .cloudtrail$get_insight_selectors_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_insight_selectors <- cloudtrail_get_insight_selectors

#' Gets event data results of a query
#'
#' @description
#' Gets event data results of a query. You must specify the `QueryID` value returned by the [`start_query`][cloudtrail_start_query] operation, and an ARN for `EventDataStore`.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/get_query_results.html](https://paws-r.github.io/docs/cloudtrail/get_query_results.html) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or ID suffix of the ARN) of the event data store against which
#' the query was run.
#' @param QueryId &#91;required&#93; The ID of the query for which you want to get results.
#' @param NextToken A token you can use to get the next page of query results.
#' @param MaxQueryResults The maximum number of query results to display on a single page.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_query_results
cloudtrail_get_query_results <- function(EventDataStore, QueryId, NextToken = NULL, MaxQueryResults = NULL) {
  op <- new_operation(
    name = "GetQueryResults",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$get_query_results_input(EventDataStore = EventDataStore, QueryId = QueryId, NextToken = NextToken, MaxQueryResults = MaxQueryResults)
  output <- .cloudtrail$get_query_results_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_query_results <- cloudtrail_get_query_results

#' Returns settings information for a specified trail
#'
#' @description
#' Returns settings information for a specified trail.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/get_trail.html](https://paws-r.github.io/docs/cloudtrail/get_trail.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name or the Amazon Resource Name (ARN) of the trail for which you
#' want to retrieve settings information.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_trail
cloudtrail_get_trail <- function(Name) {
  op <- new_operation(
    name = "GetTrail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$get_trail_input(Name = Name)
  output <- .cloudtrail$get_trail_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_trail <- cloudtrail_get_trail

#' Returns a JSON-formatted list of information about the specified trail
#'
#' @description
#' Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns trail status from a single region. To return trail status from all regions, you must call the operation on each region.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/get_trail_status.html](https://paws-r.github.io/docs/cloudtrail/get_trail_status.html) for full documentation.
#'
#' @param Name &#91;required&#93; Specifies the name or the CloudTrail ARN of the trail for which you are
#' requesting status. To get the status of a shadow trail (a replication of
#' the trail in another region), you must specify its ARN. The following is
#' the format of a trail ARN.
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_trail_status
cloudtrail_get_trail_status <- function(Name) {
  op <- new_operation(
    name = "GetTrailStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$get_trail_status_input(Name = Name)
  output <- .cloudtrail$get_trail_status_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_trail_status <- cloudtrail_get_trail_status

#' Returns information about all event data stores in the account, in the
#' current region
#'
#' @description
#' Returns information about all event data stores in the account, in the current region.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/list_event_data_stores.html](https://paws-r.github.io/docs/cloudtrail/list_event_data_stores.html) for full documentation.
#'
#' @param NextToken A token you can use to get the next page of event data store results.
#' @param MaxResults The maximum number of event data stores to display on a single page.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_event_data_stores
cloudtrail_list_event_data_stores <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEventDataStores",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$list_event_data_stores_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudtrail$list_event_data_stores_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_event_data_stores <- cloudtrail_list_event_data_stores

#' Returns all public keys whose private keys were used to sign the digest
#' files within the specified time range
#'
#' @description
#' Returns all public keys whose private keys were used to sign the digest files within the specified time range. The public key is needed to validate digest files that were signed with its corresponding private key.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/list_public_keys.html](https://paws-r.github.io/docs/cloudtrail/list_public_keys.html) for full documentation.
#'
#' @param StartTime Optionally specifies, in UTC, the start of the time range to look up
#' public keys for CloudTrail digest files. If not specified, the current
#' time is used, and the current public key is returned.
#' @param EndTime Optionally specifies, in UTC, the end of the time range to look up
#' public keys for CloudTrail digest files. If not specified, the current
#' time is used.
#' @param NextToken Reserved for future use.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_public_keys
cloudtrail_list_public_keys <- function(StartTime = NULL, EndTime = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPublicKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$list_public_keys_input(StartTime = StartTime, EndTime = EndTime, NextToken = NextToken)
  output <- .cloudtrail$list_public_keys_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_public_keys <- cloudtrail_list_public_keys

#' Returns a list of queries and query statuses for the past seven days
#'
#' @description
#' Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for `EventDataStore`. Optionally, to shorten the list of results, you can specify a time range, formatted as timestamps, by adding `StartTime` and `EndTime` parameters, and a `QueryStatus` value. Valid values for `QueryStatus` include `QUEUED`, `RUNNING`, `FINISHED`, `FAILED`, `TIMED_OUT`, or `CANCELLED`.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/list_queries.html](https://paws-r.github.io/docs/cloudtrail/list_queries.html) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or the ID suffix of the ARN) of an event data store on which
#' queries were run.
#' @param NextToken A token you can use to get the next page of results.
#' @param MaxResults The maximum number of queries to show on a page.
#' @param StartTime Use with `EndTime` to bound a [`list_queries`][cloudtrail_list_queries]
#' request, and limit its results to only those queries run within a
#' specified time period.
#' @param EndTime Use with `StartTime` to bound a
#' [`list_queries`][cloudtrail_list_queries] request, and limit its results
#' to only those queries run within a specified time period.
#' @param QueryStatus The status of queries that you want to return in results. Valid values
#' for `QueryStatus` include `QUEUED`, `RUNNING`, `FINISHED`, `FAILED`,
#' `TIMED_OUT`, or `CANCELLED`.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_queries
cloudtrail_list_queries <- function(EventDataStore, NextToken = NULL, MaxResults = NULL, StartTime = NULL, EndTime = NULL, QueryStatus = NULL) {
  op <- new_operation(
    name = "ListQueries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$list_queries_input(EventDataStore = EventDataStore, NextToken = NextToken, MaxResults = MaxResults, StartTime = StartTime, EndTime = EndTime, QueryStatus = QueryStatus)
  output <- .cloudtrail$list_queries_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_queries <- cloudtrail_list_queries

#' Lists the tags for the trail or event data store in the current region
#'
#' @description
#' Lists the tags for the trail or event data store in the current region.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/list_tags.html](https://paws-r.github.io/docs/cloudtrail/list_tags.html) for full documentation.
#'
#' @param ResourceIdList &#91;required&#93; Specifies a list of trail and event data store ARNs whose tags will be
#' listed. The list has a limit of 20 ARNs.
#' @param NextToken Reserved for future use.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_tags
cloudtrail_list_tags <- function(ResourceIdList, NextToken = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$list_tags_input(ResourceIdList = ResourceIdList, NextToken = NextToken)
  output <- .cloudtrail$list_tags_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_tags <- cloudtrail_list_tags

#' Lists trails that are in the current account
#'
#' @description
#' Lists trails that are in the current account.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/list_trails.html](https://paws-r.github.io/docs/cloudtrail/list_trails.html) for full documentation.
#'
#' @param NextToken The token to use to get the next page of results after a previous API
#' call. This token must be passed in with the same parameters that were
#' specified in the the original call. For example, if the original call
#' specified an AttributeKey of 'Username' with a value of 'root', the call
#' with NextToken should include those same parameters.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_trails
cloudtrail_list_trails <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListTrails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$list_trails_input(NextToken = NextToken)
  output <- .cloudtrail$list_trails_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_trails <- cloudtrail_list_trails

#' Looks up management events or CloudTrail Insights events that are
#' captured by CloudTrail
#'
#' @description
#' Looks up [management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events) or [CloudTrail Insights events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events) that are captured by CloudTrail. You can look up events that occurred in a region within the last 90 days. Lookup supports the following attributes for management events:
#'
#' See [https://paws-r.github.io/docs/cloudtrail/lookup_events.html](https://paws-r.github.io/docs/cloudtrail/lookup_events.html) for full documentation.
#'
#' @param LookupAttributes Contains a list of lookup attributes. Currently the list can contain
#' only one item.
#' @param StartTime Specifies that only events that occur after or at the specified time are
#' returned. If the specified start time is after the specified end time,
#' an error is returned.
#' @param EndTime Specifies that only events that occur before or at the specified time
#' are returned. If the specified end time is before the specified start
#' time, an error is returned.
#' @param EventCategory Specifies the event category. If you do not specify an event category,
#' events of the category are not returned in the response. For example, if
#' you do not specify `insight` as the value of `EventCategory`, no
#' Insights events are returned.
#' @param MaxResults The number of events to return. Possible values are 1 through 50. The
#' default is 50.
#' @param NextToken The token to use to get the next page of results after a previous API
#' call. This token must be passed in with the same parameters that were
#' specified in the the original call. For example, if the original call
#' specified an AttributeKey of 'Username' with a value of 'root', the call
#' with NextToken should include those same parameters.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_lookup_events
cloudtrail_lookup_events <- function(LookupAttributes = NULL, StartTime = NULL, EndTime = NULL, EventCategory = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "LookupEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$lookup_events_input(LookupAttributes = LookupAttributes, StartTime = StartTime, EndTime = EndTime, EventCategory = EventCategory, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudtrail$lookup_events_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$lookup_events <- cloudtrail_lookup_events

#' Configures an event selector or advanced event selectors for your trail
#'
#' @description
#' Configures an event selector or advanced event selectors for your trail. Use event selectors or advanced event selectors to specify management and data event settings for your trail. By default, trails created without specific event selectors are configured to log all read and write management events, and no data events.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/put_event_selectors.html](https://paws-r.github.io/docs/cloudtrail/put_event_selectors.html) for full documentation.
#'
#' @param TrailName &#91;required&#93; Specifies the name of the trail or trail ARN. If you specify a trail
#' name, the string must meet the following requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are not valid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' 
#' If you specify a trail ARN, it must be in the following format.
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' @param EventSelectors Specifies the settings for your event selectors. You can configure up to
#' five event selectors for a trail. You can use either `EventSelectors` or
#' `AdvancedEventSelectors` in a
#' [`put_event_selectors`][cloudtrail_put_event_selectors] request, but not
#' both. If you apply `EventSelectors` to a trail, any existing
#' `AdvancedEventSelectors` are overwritten.
#' @param AdvancedEventSelectors Specifies the settings for advanced event selectors. You can add
#' advanced event selectors, and conditions for your advanced event
#' selectors, up to a maximum of 500 values for all conditions and
#' selectors on a trail. You can use either `AdvancedEventSelectors` or
#' `EventSelectors`, but not both. If you apply `AdvancedEventSelectors` to
#' a trail, any existing `EventSelectors` are overwritten. For more
#' information about advanced event selectors, see [Logging data events for
#' trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html)
#' in the *CloudTrail User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_put_event_selectors
cloudtrail_put_event_selectors <- function(TrailName, EventSelectors = NULL, AdvancedEventSelectors = NULL) {
  op <- new_operation(
    name = "PutEventSelectors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$put_event_selectors_input(TrailName = TrailName, EventSelectors = EventSelectors, AdvancedEventSelectors = AdvancedEventSelectors)
  output <- .cloudtrail$put_event_selectors_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$put_event_selectors <- cloudtrail_put_event_selectors

#' Lets you enable Insights event logging by specifying the Insights
#' selectors that you want to enable on an existing trail
#'
#' @description
#' Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing trail. You also use [`put_insight_selectors`][cloudtrail_put_insight_selectors] to turn off Insights event logging, by passing an empty list of insight types. The valid Insights event types in this release are `ApiErrorRateInsight` and `ApiCallRateInsight`.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/put_insight_selectors.html](https://paws-r.github.io/docs/cloudtrail/put_insight_selectors.html) for full documentation.
#'
#' @param TrailName &#91;required&#93; The name of the CloudTrail trail for which you want to change or add
#' Insights selectors.
#' @param InsightSelectors &#91;required&#93; A JSON string that contains the insight types you want to log on a
#' trail. `ApiCallRateInsight` and `ApiErrorRateInsight` are valid insight
#' types.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_put_insight_selectors
cloudtrail_put_insight_selectors <- function(TrailName, InsightSelectors) {
  op <- new_operation(
    name = "PutInsightSelectors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$put_insight_selectors_input(TrailName = TrailName, InsightSelectors = InsightSelectors)
  output <- .cloudtrail$put_insight_selectors_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$put_insight_selectors <- cloudtrail_put_insight_selectors

#' Removes the specified tags from a trail or event data store
#'
#' @description
#' Removes the specified tags from a trail or event data store.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/remove_tags.html](https://paws-r.github.io/docs/cloudtrail/remove_tags.html) for full documentation.
#'
#' @param ResourceId &#91;required&#93; Specifies the ARN of the trail or event data store from which tags
#' should be removed.
#' 
#' Example trail ARN format:
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' 
#' Example event data store ARN format:
#' `arn:aws:cloudtrail:us-east-2:12345678910:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
#' @param TagsList &#91;required&#93; Specifies a list of tags to be removed.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_remove_tags
cloudtrail_remove_tags <- function(ResourceId, TagsList) {
  op <- new_operation(
    name = "RemoveTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$remove_tags_input(ResourceId = ResourceId, TagsList = TagsList)
  output <- .cloudtrail$remove_tags_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$remove_tags <- cloudtrail_remove_tags

#' Restores a deleted event data store specified by EventDataStore, which
#' accepts an event data store ARN
#'
#' @description
#' Restores a deleted event data store specified by `EventDataStore`, which accepts an event data store ARN. You can only restore a deleted event data store within the seven-day wait period after deletion. Restoring an event data store can take several minutes, depending on the size of the event data store.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/restore_event_data_store.html](https://paws-r.github.io/docs/cloudtrail/restore_event_data_store.html) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or the ID suffix of the ARN) of the event data store that you
#' want to restore.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_restore_event_data_store
cloudtrail_restore_event_data_store <- function(EventDataStore) {
  op <- new_operation(
    name = "RestoreEventDataStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$restore_event_data_store_input(EventDataStore = EventDataStore)
  output <- .cloudtrail$restore_event_data_store_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$restore_event_data_store <- cloudtrail_restore_event_data_store

#' Starts the recording of Amazon Web Services API calls and log file
#' delivery for a trail
#'
#' @description
#' Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is enabled in all regions, this operation must be called from the region in which the trail was created. This operation cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled in all regions.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/start_logging.html](https://paws-r.github.io/docs/cloudtrail/start_logging.html) for full documentation.
#'
#' @param Name &#91;required&#93; Specifies the name or the CloudTrail ARN of the trail for which
#' CloudTrail logs Amazon Web Services API calls. The following is the
#' format of a trail ARN.
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @keywords internal
#'
#' @rdname cloudtrail_start_logging
cloudtrail_start_logging <- function(Name) {
  op <- new_operation(
    name = "StartLogging",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$start_logging_input(Name = Name)
  output <- .cloudtrail$start_logging_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$start_logging <- cloudtrail_start_logging

#' Starts a CloudTrail Lake query
#'
#' @description
#' Starts a CloudTrail Lake query. The required `QueryStatement` parameter provides your SQL query, enclosed in single quotation marks.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/start_query.html](https://paws-r.github.io/docs/cloudtrail/start_query.html) for full documentation.
#'
#' @param QueryStatement &#91;required&#93; The SQL code of your query.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_start_query
cloudtrail_start_query <- function(QueryStatement) {
  op <- new_operation(
    name = "StartQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$start_query_input(QueryStatement = QueryStatement)
  output <- .cloudtrail$start_query_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$start_query <- cloudtrail_start_query

#' Suspends the recording of Amazon Web Services API calls and log file
#' delivery for the specified trail
#'
#' @description
#' Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most circumstances, there is no need to use this action. You can update a trail without stopping it first. This action is the only way to stop recording. For a trail enabled in all regions, this operation must be called from the region in which the trail was created, or an `InvalidHomeRegionException` will occur. This operation cannot be called on the shadow trails (replicated trails in other regions) of a trail enabled in all regions.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/stop_logging.html](https://paws-r.github.io/docs/cloudtrail/stop_logging.html) for full documentation.
#'
#' @param Name &#91;required&#93; Specifies the name or the CloudTrail ARN of the trail for which
#' CloudTrail will stop logging Amazon Web Services API calls. The
#' following is the format of a trail ARN.
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @keywords internal
#'
#' @rdname cloudtrail_stop_logging
cloudtrail_stop_logging <- function(Name) {
  op <- new_operation(
    name = "StopLogging",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$stop_logging_input(Name = Name)
  output <- .cloudtrail$stop_logging_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$stop_logging <- cloudtrail_stop_logging

#' Updates an event data store
#'
#' @description
#' Updates an event data store. The required `EventDataStore` value is an ARN or the ID portion of the ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws an error. `RetentionPeriod` is in days, and valid values are integers between 90 and 2555. By default, `TerminationProtection` is enabled. `AdvancedEventSelectors` includes or excludes management and data events in your event data store; for more information about `AdvancedEventSelectors`, see PutEventSelectorsRequest$AdvancedEventSelectors.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/update_event_data_store.html](https://paws-r.github.io/docs/cloudtrail/update_event_data_store.html) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or the ID suffix of the ARN) of the event data store that you
#' want to update.
#' @param Name The event data store name.
#' @param AdvancedEventSelectors The advanced event selectors used to select events for the event data
#' store.
#' @param MultiRegionEnabled Specifies whether an event data store collects events from all regions,
#' or only from the region in which it was created.
#' @param OrganizationEnabled Specifies whether an event data store collects events logged for an
#' organization in Organizations.
#' @param RetentionPeriod The retention period, in days.
#' @param TerminationProtectionEnabled Indicates that termination protection is enabled and the event data
#' store cannot be automatically deleted.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_update_event_data_store
cloudtrail_update_event_data_store <- function(EventDataStore, Name = NULL, AdvancedEventSelectors = NULL, MultiRegionEnabled = NULL, OrganizationEnabled = NULL, RetentionPeriod = NULL, TerminationProtectionEnabled = NULL) {
  op <- new_operation(
    name = "UpdateEventDataStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$update_event_data_store_input(EventDataStore = EventDataStore, Name = Name, AdvancedEventSelectors = AdvancedEventSelectors, MultiRegionEnabled = MultiRegionEnabled, OrganizationEnabled = OrganizationEnabled, RetentionPeriod = RetentionPeriod, TerminationProtectionEnabled = TerminationProtectionEnabled)
  output <- .cloudtrail$update_event_data_store_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$update_event_data_store <- cloudtrail_update_event_data_store

#' Updates trail settings that control what events you are logging, and how
#' to handle log files
#'
#' @description
#' Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery. If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the bucket. [`update_trail`][cloudtrail_update_trail] must be called from the region in which the trail was created; otherwise, an `InvalidHomeRegionException` is thrown.
#'
#' See [https://paws-r.github.io/docs/cloudtrail/update_trail.html](https://paws-r.github.io/docs/cloudtrail/update_trail.html) for full documentation.
#'
#' @param Name &#91;required&#93; Specifies the name of the trail or trail ARN. If `Name` is a trail name,
#' the string must meet the following requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are not valid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' 
#' If `Name` is a trail ARN, it must be in the following format.
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' @param S3BucketName Specifies the name of the Amazon S3 bucket designated for publishing log
#' files. See [Amazon S3 Bucket Naming
#' Requirements](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-s3-bucket-naming-requirements.html).
#' @param S3KeyPrefix Specifies the Amazon S3 key prefix that comes after the name of the
#' bucket you have designated for log file delivery. For more information,
#' see [Finding Your CloudTrail Log
#' Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
#' The maximum length is 200 characters.
#' @param SnsTopicName Specifies the name of the Amazon SNS topic defined for notification of
#' log file delivery. The maximum length is 256 characters.
#' @param IncludeGlobalServiceEvents Specifies whether the trail is publishing events from global services
#' such as IAM to the log files.
#' @param IsMultiRegionTrail Specifies whether the trail applies only to the current region or to all
#' regions. The default is false. If the trail exists only in the current
#' region and this value is set to true, shadow trails (replications of the
#' trail) will be created in the other regions. If the trail exists in all
#' regions and this value is set to false, the trail will remain in the
#' region where it was created, and its shadow trails in other regions will
#' be deleted. As a best practice, consider using trails that log events in
#' all regions.
#' @param EnableLogFileValidation Specifies whether log file validation is enabled. The default is false.
#' 
#' When you disable log file integrity validation, the chain of digest
#' files is broken after one hour. CloudTrail does not create digest files
#' for log files that were delivered during a period in which log file
#' integrity validation was disabled. For example, if you enable log file
#' integrity validation at noon on January 1, disable it at noon on January
#' 2, and re-enable it at noon on January 10, digest files will not be
#' created for the log files delivered from noon on January 2 to noon on
#' January 10. The same applies whenever you stop CloudTrail logging or
#' delete a trail.
#' @param CloudWatchLogsLogGroupArn Specifies a log group name using an Amazon Resource Name (ARN), a unique
#' identifier that represents the log group to which CloudTrail logs are
#' delivered. Not required unless you specify `CloudWatchLogsRoleArn`.
#' @param CloudWatchLogsRoleArn Specifies the role for the CloudWatch Logs endpoint to assume to write
#' to a user's log group.
#' @param KmsKeyId Specifies the KMS key ID to use to encrypt the logs delivered by
#' CloudTrail. The value can be an alias name prefixed by "alias/", a fully
#' specified ARN to an alias, a fully specified ARN to a key, or a globally
#' unique identifier.
#' 
#' CloudTrail also supports KMS multi-Region keys. For more information
#' about multi-Region keys, see [Using multi-Region
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
#' in the *Key Management Service Developer Guide*.
#' 
#' Examples:
#' 
#' -   alias/MyAliasName
#' 
#' -   arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
#' 
#' -   arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
#' 
#' -   12345678-1234-1234-1234-123456789012
#' @param IsOrganizationTrail Specifies whether the trail is applied to all accounts in an
#' organization in Organizations, or only for the current Amazon Web
#' Services account. The default is false, and cannot be true unless the
#' call is made on behalf of an Amazon Web Services account that is the
#' management account for an organization in Organizations. If the trail is
#' not an organization trail and this is set to `true`, the trail will be
#' created in all Amazon Web Services accounts that belong to the
#' organization. If the trail is an organization trail and this is set to
#' `false`, the trail will remain in the current Amazon Web Services
#' account but be deleted from all member accounts in the organization.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_update_trail
cloudtrail_update_trail <- function(Name, S3BucketName = NULL, S3KeyPrefix = NULL, SnsTopicName = NULL, IncludeGlobalServiceEvents = NULL, IsMultiRegionTrail = NULL, EnableLogFileValidation = NULL, CloudWatchLogsLogGroupArn = NULL, CloudWatchLogsRoleArn = NULL, KmsKeyId = NULL, IsOrganizationTrail = NULL) {
  op <- new_operation(
    name = "UpdateTrail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudtrail$update_trail_input(Name = Name, S3BucketName = S3BucketName, S3KeyPrefix = S3KeyPrefix, SnsTopicName = SnsTopicName, IncludeGlobalServiceEvents = IncludeGlobalServiceEvents, IsMultiRegionTrail = IsMultiRegionTrail, EnableLogFileValidation = EnableLogFileValidation, CloudWatchLogsLogGroupArn = CloudWatchLogsLogGroupArn, CloudWatchLogsRoleArn = CloudWatchLogsRoleArn, KmsKeyId = KmsKeyId, IsOrganizationTrail = IsOrganizationTrail)
  output <- .cloudtrail$update_trail_output()
  config <- get_config()
  svc <- .cloudtrail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$update_trail <- cloudtrail_update_trail
