% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_describe_stack_set}
\alias{cloudformation_describe_stack_set}
\title{Returns the description of the specified stack set}
\usage{
cloudformation_describe_stack_set(StackSetName, CallAs = NULL)
}
\arguments{
\item{StackSetName}{[required] The name or unique ID of the stack set whose description you want.}

\item{CallAs}{[Service-managed permissions] Specifies whether you are acting as an
account administrator in the organization's management account or as a
delegated administrator in a member account.

By default, \code{SELF} is specified. Use \code{SELF} for stack sets with
self-managed permissions.
\itemize{
\item If you are signed in to the management account, specify \code{SELF}.
\item If you are signed in to a delegated administrator account, specify
\code{DELEGATED_ADMIN}.

Your Amazon Web Services account must be registered as a delegated
administrator in the management account. For more information, see
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html}{Register a delegated administrator}
in the \emph{CloudFormation User Guide}.
}}
}
\description{
Returns the description of the specified stack set.

See \url{https://paws-r.github.io/docs/cloudformation/describe_stack_set.html} for full documentation.
}
\keyword{internal}
