% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_create_trail}
\alias{cloudtrail_create_trail}
\title{Creates a trail that specifies the settings for delivery of log data to
an Amazon S3 bucket}
\usage{
cloudtrail_create_trail(
  Name,
  S3BucketName,
  S3KeyPrefix = NULL,
  SnsTopicName = NULL,
  IncludeGlobalServiceEvents = NULL,
  IsMultiRegionTrail = NULL,
  EnableLogFileValidation = NULL,
  CloudWatchLogsLogGroupArn = NULL,
  CloudWatchLogsRoleArn = NULL,
  KmsKeyId = NULL,
  IsOrganizationTrail = NULL,
  TagsList = NULL
)
}
\arguments{
\item{Name}{[required] Specifies the name of the trail. The name must meet the following
requirements:
\itemize{
\item Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
underscores (_), or dashes (-)
\item Start with a letter or number, and end with a letter or number
\item Be between 3 and 128 characters
\item Have no adjacent periods, underscores or dashes. Names like
\verb{my-_namespace} and \code{my--namespace} are not valid.
\item Not be in IP address format (for example, 192.168.5.4)
}}

\item{S3BucketName}{[required] Specifies the name of the Amazon S3 bucket designated for publishing log
files. See \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-s3-bucket-naming-requirements.html}{Amazon S3 Bucket Naming Requirements}.}

\item{S3KeyPrefix}{Specifies the Amazon S3 key prefix that comes after the name of the
bucket you have designated for log file delivery. For more information,
see \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html}{Finding Your CloudTrail Log Files}.
The maximum length is 200 characters.}

\item{SnsTopicName}{Specifies the name of the Amazon SNS topic defined for notification of
log file delivery. The maximum length is 256 characters.}

\item{IncludeGlobalServiceEvents}{Specifies whether the trail is publishing events from global services
such as IAM to the log files.}

\item{IsMultiRegionTrail}{Specifies whether the trail is created in the current region or in all
regions. The default is false, which creates a trail only in the region
where you are signed in. As a best practice, consider creating trails
that log events in all regions.}

\item{EnableLogFileValidation}{Specifies whether log file integrity validation is enabled. The default
is false.

When you disable log file integrity validation, the chain of digest
files is broken after one hour. CloudTrail does not create digest files
for log files that were delivered during a period in which log file
integrity validation was disabled. For example, if you enable log file
integrity validation at noon on January 1, disable it at noon on January
2, and re-enable it at noon on January 10, digest files will not be
created for the log files delivered from noon on January 2 to noon on
January 10. The same applies whenever you stop CloudTrail logging or
delete a trail.}

\item{CloudWatchLogsLogGroupArn}{Specifies a log group name using an Amazon Resource Name (ARN), a unique
identifier that represents the log group to which CloudTrail logs will
be delivered. Not required unless you specify \code{CloudWatchLogsRoleArn}.}

\item{CloudWatchLogsRoleArn}{Specifies the role for the CloudWatch Logs endpoint to assume to write
to a user's log group.}

\item{KmsKeyId}{Specifies the KMS key ID to use to encrypt the logs delivered by
CloudTrail. The value can be an alias name prefixed by "alias/", a fully
specified ARN to an alias, a fully specified ARN to a key, or a globally
unique identifier.

CloudTrail also supports KMS multi-Region keys. For more information
about multi-Region keys, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html}{Using multi-Region keys}
in the \emph{Key Management Service Developer Guide}.

Examples:
\itemize{
\item alias/MyAliasName
\item arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
\item arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
\item 12345678-1234-1234-1234-123456789012
}}

\item{IsOrganizationTrail}{Specifies whether the trail is created for all accounts in an
organization in Organizations, or only for the current Amazon Web
Services account. The default is false, and cannot be true unless the
call is made on behalf of an Amazon Web Services account that is the
management account for an organization in Organizations.}

\item{TagsList}{}
}
\description{
Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.

See \url{https://paws-r.github.io/docs/cloudtrail/create_trail.html} for full documentation.
}
\keyword{internal}
