% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_create_service_action}
\alias{servicecatalog_create_service_action}
\title{Creates a self-service action}
\usage{
servicecatalog_create_service_action(
  Name,
  DefinitionType,
  Definition,
  Description = NULL,
  AcceptLanguage = NULL,
  IdempotencyToken
)
}
\arguments{
\item{Name}{[required] The self-service action name.}

\item{DefinitionType}{[required] The service action definition type. For example, \code{SSM_AUTOMATION}.}

\item{Definition}{[required] The self-service action definition. Can be one of the following:

\strong{Name}

The name of the AWS Systems Manager document (SSM document). For
example, \code{AWS-RestartEC2Instance}.

If you are using a shared SSM document, you must provide the ARN instead
of the name.

\strong{Version}

The AWS Systems Manager automation document version. For example,
\code{"Version": "1"}

\strong{AssumeRole}

The Amazon Resource Name (ARN) of the role that performs the
self-service actions on your behalf. For example,
\code{"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"}.

To reuse the provisioned product launch role, set to
\code{"AssumeRole": "LAUNCH_ROLE"}.

\strong{Parameters}

The list of parameters in JSON format.

For example: \verb{[\{\\"Name\\":\\"InstanceId\\",\\"Type\\":\\"TARGET\\"\}]} or
\verb{[\{\\"Name\\":\\"InstanceId\\",\\"Type\\":\\"TEXT_VALUE\\"\}]}.}

\item{Description}{The self-service action description.}

\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{IdempotencyToken}{[required] A unique identifier that you provide to ensure idempotency. If multiple
requests differ only by the idempotency token, the same response is
returned for each repeated request.}
}
\description{
Creates a self-service action.

See \url{https://paws-r.github.io/docs/servicecatalog/create_service_action.html} for full documentation.
}
\keyword{internal}
