% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_import_as_provisioned_product}
\alias{servicecatalog_import_as_provisioned_product}
\title{Requests the import of a resource as a Service Catalog provisioned
product that is associated to a Service Catalog product and provisioning
artifact}
\usage{
servicecatalog_import_as_provisioned_product(
  AcceptLanguage = NULL,
  ProductId,
  ProvisioningArtifactId,
  ProvisionedProductName,
  PhysicalId,
  IdempotencyToken
)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProductId}{[required] The product identifier.}

\item{ProvisioningArtifactId}{[required] The identifier of the provisioning artifact.}

\item{ProvisionedProductName}{[required] The user-friendly name of the provisioned product. The value must be
unique for the AWS account. The name cannot be updated after the product
is provisioned.}

\item{PhysicalId}{[required] The unique identifier of the resource to be imported. It only currently
supports CloudFormation stack IDs.}

\item{IdempotencyToken}{[required] A unique identifier that you provide to ensure idempotency. If multiple
requests differ only by the idempotency token, the same response is
returned for each repeated request.}
}
\description{
Requests the import of a resource as a Service Catalog provisioned product that is associated to a Service Catalog product and provisioning artifact. Once imported, all supported Service Catalog governance actions are supported on the provisioned product.

See \url{https://paws-r.github.io/docs/servicecatalog/import_as_provisioned_product.html} for full documentation.
}
\keyword{internal}
