% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_update_provisioned_product}
\alias{servicecatalog_update_provisioned_product}
\title{Requests updates to the configuration of the specified provisioned
product}
\usage{
servicecatalog_update_provisioned_product(
  AcceptLanguage = NULL,
  ProvisionedProductName = NULL,
  ProvisionedProductId = NULL,
  ProductId = NULL,
  ProductName = NULL,
  ProvisioningArtifactId = NULL,
  ProvisioningArtifactName = NULL,
  PathId = NULL,
  PathName = NULL,
  ProvisioningParameters = NULL,
  ProvisioningPreferences = NULL,
  Tags = NULL,
  UpdateToken
)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProvisionedProductName}{The name of the provisioned product. You cannot specify both
\code{ProvisionedProductName} and \code{ProvisionedProductId}.}

\item{ProvisionedProductId}{The identifier of the provisioned product. You must provide the name or
ID, but not both.}

\item{ProductId}{The identifier of the product. You must provide the name or ID, but not
both.}

\item{ProductName}{The name of the product. You must provide the name or ID, but not both.}

\item{ProvisioningArtifactId}{The identifier of the provisioning artifact.}

\item{ProvisioningArtifactName}{The name of the provisioning artifact. You must provide the name or ID,
but not both.}

\item{PathId}{The path identifier. This value is optional if the product has a default
path, and required if the product has more than one path. You must
provide the name or ID, but not both.}

\item{PathName}{The name of the path. You must provide the name or ID, but not both.}

\item{ProvisioningParameters}{The new parameters.}

\item{ProvisioningPreferences}{An object that contains information about the provisioning preferences
for a stack set.}

\item{Tags}{One or more tags. Requires the product to have \code{RESOURCE_UPDATE}
constraint with \code{TagUpdatesOnProvisionedProduct} set to \code{ALLOWED} to
allow tag updates.}

\item{UpdateToken}{[required] The idempotency token that uniquely identifies the provisioning update
request.}
}
\description{
Requests updates to the configuration of the specified provisioned product.

See \url{https://paws-r.github.io/docs/servicecatalog/update_provisioned_product.html} for full documentation.
}
\keyword{internal}
