% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_add_tags_to_resource}
\alias{ssm_add_tags_to_resource}
\title{Adds or overwrites one or more tags for the specified resource}
\usage{
ssm_add_tags_to_resource(ResourceType, ResourceId, Tags)
}
\arguments{
\item{ResourceType}{[required] Specifies the type of resource you are tagging.

The \code{ManagedInstance} type for this API operation is for on-premises
managed nodes. You must specify the name of the managed node in the
following format: \code{mi-ID_number }. For example, \verb{mi-1a2b3c4d5e6f}.}

\item{ResourceId}{[required] The resource ID you want to tag.

Use the ID of the resource. Here are some examples:

\code{MaintenanceWindow}: \verb{mw-012345abcde}

\code{PatchBaseline}: \verb{pb-012345abcde}

\code{Automation}: \verb{example-c160-4567-8519-012345abcde}

\code{OpsMetadata} object: \code{ResourceID} for tagging is created from the
Amazon Resource Name (ARN) for the object. Specifically, \code{ResourceID} is
created from the strings that come after the word \code{opsmetadata} in the
ARN. For example, an OpsMetadata object with an ARN of
\code{arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager}
has a \code{ResourceID} of either \code{aws/ssm/MyGroup/appmanager} or
\verb{/aws/ssm/MyGroup/appmanager}.

For the \code{Document} and \code{Parameter} values, use the name of the resource.

\code{ManagedInstance}: \verb{mi-012345abcde}

The \code{ManagedInstance} type for this API operation is only for
on-premises managed nodes. You must specify the name of the managed node
in the following format: \code{mi-ID_number }. For example,
\verb{mi-1a2b3c4d5e6f}.}

\item{Tags}{[required] One or more tags. The value parameter is required.

Don't enter personally identifiable information in this field.}
}
\description{
Adds or overwrites one or more tags for the specified resource. \emph{Tags} are metadata that you can assign to your automations, documents, managed nodes, maintenance windows, Parameter Store parameters, and patch baselines. Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value, both of which you define. For example, you could define a set of tags for your account's managed nodes that helps you track each node's owner and stack level. For example:

See \url{https://paws-r.github.io/docs/ssm/add_tags_to_resource.html} for full documentation.
}
\keyword{internal}
