% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_parameter_history}
\alias{ssm_get_parameter_history}
\title{Retrieves the history of all changes to a parameter}
\usage{
ssm_get_parameter_history(
  Name,
  WithDecryption = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{Name}{[required] The name of the parameter for which you want to review history.}

\item{WithDecryption}{Return decrypted values for secure string parameters. This flag is
ignored for \code{String} and \code{StringList} parameter types.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}
}
\description{
Retrieves the history of all changes to a parameter.

See \url{https://paws-r.github.io/docs/ssm/get_parameter_history.html} for full documentation.
}
\keyword{internal}
