% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchrum_operations.R
\name{cloudwatchrum_batch_get_rum_metric_definitions}
\alias{cloudwatchrum_batch_get_rum_metric_definitions}
\title{Retrieves the list of metrics and dimensions that a RUM app monitor is
sending to a single destination}
\usage{
cloudwatchrum_batch_get_rum_metric_definitions(
  AppMonitorName,
  Destination,
  DestinationArn = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{AppMonitorName}{[required] The name of the CloudWatch RUM app monitor that is sending the metrics.}

\item{Destination}{[required] The type of destination that you want to view metrics for. Valid values
are \code{CloudWatch} and \code{Evidently}.}

\item{DestinationArn}{This parameter is required if \code{Destination} is \code{Evidently}. If
\code{Destination} is \code{CloudWatch}, do not use this parameter.

This parameter specifies the ARN of the Evidently experiment that
corresponds to the destination.}

\item{MaxResults}{The maximum number of results to return in one operation. The default is
50. The maximum that you can specify is 100.

To retrieve the remaining results, make another call with the returned
\code{NextToken} value.}

\item{NextToken}{Use the token returned by the previous operation to request the next
page of results.}
}
\description{
Retrieves the list of metrics and dimensions that a RUM app monitor is sending to a single destination.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchrum_batch_get_rum_metric_definitions/} for full documentation.
}
\keyword{internal}
