% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_register_instance}
\alias{opsworks_register_instance}
\title{Registers instances that were created outside of AWS OpsWorks Stacks
with a specified stack}
\usage{
opsworks_register_instance(
  StackId,
  Hostname = NULL,
  PublicIp = NULL,
  PrivateIp = NULL,
  RsaPublicKey = NULL,
  RsaPublicKeyFingerprint = NULL,
  InstanceIdentity = NULL
)
}
\arguments{
\item{StackId}{[required] The ID of the stack that the instance is to be registered with.}

\item{Hostname}{The instance's hostname.}

\item{PublicIp}{The instance's public IP address.}

\item{PrivateIp}{The instance's private IP address.}

\item{RsaPublicKey}{The instances public RSA key. This key is used to encrypt communication
between the instance and the service.}

\item{RsaPublicKeyFingerprint}{The instances public RSA key fingerprint.}

\item{InstanceIdentity}{An InstanceIdentity object that contains the instance's identity.}
}
\description{
Registers instances that were created outside of AWS OpsWorks Stacks with a specified stack.

See \url{https://www.paws-r-sdk.com/docs/opsworks_register_instance/} for full documentation.
}
\keyword{internal}
