% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_put_resource_policy}
\alias{organizations_put_resource_policy}
\title{Creates or updates a resource policy}
\usage{
organizations_put_resource_policy(Content, Tags = NULL)
}
\arguments{
\item{Content}{[required] If provided, the new content for the resource policy. The text must be
correctly formatted JSON that complies with the syntax for the resource
policy's type. For more information, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps_syntax.html}{Service Control Policy Syntax}
in the \emph{Organizations User Guide.}}

\item{Tags}{A list of tags that you want to attach to the newly created resource
policy. For each tag in the list, you must specify both a tag key and a
value. You can set the value to an empty string, but you can't set it to
\code{null}. For more information about tagging, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html}{Tagging Organizations resources}
in the Organizations User Guide.

Calls with tags apply to the initial creation of the resource policy,
otherwise an exception is thrown. If any one of the tags is not valid or
if you exceed the allowed number of tags for the resource policy, then
the entire request fails and the resource policy is not created.}
}
\description{
Creates or updates a resource policy.

See \url{https://www.paws-r-sdk.com/docs/organizations_put_resource_policy/} for full documentation.
}
\keyword{internal}
