% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_create_partner_event_source}
\alias{cloudwatchevents_create_partner_event_source}
\title{Called by an SaaS partner to create a partner event source}
\usage{
cloudwatchevents_create_partner_event_source(Name, Account)
}
\arguments{
\item{Name}{[required] The name of the partner event source. This name must be unique and must
be in the format \code{partner_name/event_namespace/event_name}. The Amazon
Web Services account that wants to use this partner event source must
create a partner event bus with a name that matches the name of the
partner event source.}

\item{Account}{[required] The Amazon Web Services account ID that is permitted to create a
matching partner event bus for this partner event source.}
}
\description{
Called by an SaaS partner to create a partner event source. This operation is not used by Amazon Web Services customers.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchevents_create_partner_event_source/} for full documentation.
}
\keyword{internal}
