# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include managedgrafana_service.R
NULL

#' Assigns a Grafana Enterprise license to a workspace
#'
#' @description
#' Assigns a Grafana Enterprise license to a workspace. Upgrading to Grafana Enterprise incurs additional fees. For more information, see [Upgrade a workspace to Grafana Enterprise](https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html).
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_associate_license/](https://www.paws-r-sdk.com/docs/managedgrafana_associate_license/) for full documentation.
#'
#' @param licenseType &#91;required&#93; The type of license to associate with the workspace.
#' @param workspaceId &#91;required&#93; The ID of the workspace to associate the license with.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_associate_license
managedgrafana_associate_license <- function(licenseType, workspaceId) {
  op <- new_operation(
    name = "AssociateLicense",
    http_method = "POST",
    http_path = "/workspaces/{workspaceId}/licenses/{licenseType}",
    paginator = list()
  )
  input <- .managedgrafana$associate_license_input(licenseType = licenseType, workspaceId = workspaceId)
  output <- .managedgrafana$associate_license_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$associate_license <- managedgrafana_associate_license

#' Creates a workspace
#'
#' @description
#' Creates a *workspace*. In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_create_workspace/](https://www.paws-r-sdk.com/docs/managedgrafana_create_workspace/) for full documentation.
#'
#' @param accountAccessType &#91;required&#93; Specifies whether the workspace can access Amazon Web Services resources
#' in this Amazon Web Services account only, or whether it can also access
#' Amazon Web Services resources in other accounts in the same
#' organization. If you specify `ORGANIZATION`, you must specify which
#' organizational units the workspace can access in the
#' `workspaceOrganizationalUnits` parameter.
#' @param authenticationProviders &#91;required&#93; Specifies whether this workspace uses SAML 2.0, IAM Identity Center
#' (successor to Single Sign-On), or both to authenticate users for using
#' the Grafana console within a workspace. For more information, see [User
#' authentication in Amazon Managed
#' Grafana](https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html).
#' @param clientToken A unique, case-sensitive, user-provided identifier to ensure the
#' idempotency of the request.
#' @param configuration The configuration string for the workspace that you create. For more
#' information about the format and configuration options available, see
#' [Working in your Grafana
#' workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
#' @param grafanaVersion Specifies the version of Grafana to support in the new workspace.
#' 
#' To get a list of supported version, use the
#' [`list_versions`][managedgrafana_list_versions] operation.
#' @param networkAccessControl Configuration for network access to your workspace.
#' 
#' When this is configured, only listed IP addresses and VPC endpoints will
#' be able to access your workspace. Standard Grafana authentication and
#' authorization will still be required.
#' 
#' If this is not configured, or is removed, then all IP addresses and VPC
#' endpoints will be allowed. Standard Grafana authentication and
#' authorization will still be required.
#' @param organizationRoleName The name of an IAM role that already exists to use with Organizations to
#' access Amazon Web Services data sources and notification channels in
#' other accounts in an organization.
#' @param permissionType &#91;required&#93; When creating a workspace through the Amazon Web Services API, CLI or
#' Amazon Web Services CloudFormation, you must manage IAM roles and
#' provision the permissions that the workspace needs to use Amazon Web
#' Services data sources and notification channels.
#' 
#' You must also specify a `workspaceRoleArn` for a role that you will
#' manage for the workspace to use when accessing those datasources and
#' notification channels.
#' 
#' The ability for Amazon Managed Grafana to create and update IAM roles on
#' behalf of the user is supported only in the Amazon Managed Grafana
#' console, where this value may be set to `SERVICE_MANAGED`.
#' 
#' Use only the `CUSTOMER_MANAGED` permission type when creating a
#' workspace with the API, CLI or Amazon Web Services CloudFormation.
#' 
#' For more information, see [Amazon Managed Grafana permissions and
#' policies for Amazon Web Services data sources and notification
#' channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html).
#' @param stackSetName The name of the CloudFormation stack set to use to generate IAM roles to
#' be used for this workspace.
#' @param tags The list of tags associated with the workspace.
#' @param vpcConfiguration The configuration settings for an Amazon VPC that contains data sources
#' for your Grafana workspace to connect to.
#' 
#' Connecting to a private VPC is not yet available in the Asia Pacific
#' (Seoul) Region (ap-northeast-2).
#' @param workspaceDataSources This parameter is for internal use only, and should not be used.
#' @param workspaceDescription A description for the workspace. This is used only to help you identify
#' this workspace.
#' 
#' Pattern: `^[\\p{L}\\p{Z}\\p{N}\\p{P}]{0,2048}$`
#' @param workspaceName The name for the workspace. It does not have to be unique.
#' @param workspaceNotificationDestinations Specify the Amazon Web Services notification channels that you plan to
#' use in this workspace. Specifying these data sources here enables Amazon
#' Managed Grafana to create IAM roles and permissions that allow Amazon
#' Managed Grafana to use these channels.
#' @param workspaceOrganizationalUnits Specifies the organizational units that this workspace is allowed to use
#' data sources from, if this workspace is in an account that is part of an
#' organization.
#' @param workspaceRoleArn Specified the IAM role that grants permissions to the Amazon Web
#' Services resources that the workspace will view data from, including
#' both data sources and notification channels. You are responsible for
#' managing the permissions for this role as new data sources or
#' notification channels are added.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_create_workspace
managedgrafana_create_workspace <- function(accountAccessType, authenticationProviders, clientToken = NULL, configuration = NULL, grafanaVersion = NULL, networkAccessControl = NULL, organizationRoleName = NULL, permissionType, stackSetName = NULL, tags = NULL, vpcConfiguration = NULL, workspaceDataSources = NULL, workspaceDescription = NULL, workspaceName = NULL, workspaceNotificationDestinations = NULL, workspaceOrganizationalUnits = NULL, workspaceRoleArn = NULL) {
  op <- new_operation(
    name = "CreateWorkspace",
    http_method = "POST",
    http_path = "/workspaces",
    paginator = list()
  )
  input <- .managedgrafana$create_workspace_input(accountAccessType = accountAccessType, authenticationProviders = authenticationProviders, clientToken = clientToken, configuration = configuration, grafanaVersion = grafanaVersion, networkAccessControl = networkAccessControl, organizationRoleName = organizationRoleName, permissionType = permissionType, stackSetName = stackSetName, tags = tags, vpcConfiguration = vpcConfiguration, workspaceDataSources = workspaceDataSources, workspaceDescription = workspaceDescription, workspaceName = workspaceName, workspaceNotificationDestinations = workspaceNotificationDestinations, workspaceOrganizationalUnits = workspaceOrganizationalUnits, workspaceRoleArn = workspaceRoleArn)
  output <- .managedgrafana$create_workspace_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$create_workspace <- managedgrafana_create_workspace

#' Creates a Grafana API key for the workspace
#'
#' @description
#' Creates a Grafana API key for the workspace. This key can be used to authenticate requests sent to the workspace's HTTP API. See <https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html> for available APIs and example requests.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_create_workspace_api_key/](https://www.paws-r-sdk.com/docs/managedgrafana_create_workspace_api_key/) for full documentation.
#'
#' @param keyName &#91;required&#93; Specifies the name of the key. Keynames must be unique to the workspace.
#' @param keyRole &#91;required&#93; Specifies the permission level of the key.
#' 
#' Valid values: `VIEWER`|`EDITOR`|`ADMIN`
#' @param secondsToLive &#91;required&#93; Specifies the time in seconds until the key expires. Keys can be valid
#' for up to 30 days.
#' @param workspaceId &#91;required&#93; The ID of the workspace to create an API key.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_create_workspace_api_key
managedgrafana_create_workspace_api_key <- function(keyName, keyRole, secondsToLive, workspaceId) {
  op <- new_operation(
    name = "CreateWorkspaceApiKey",
    http_method = "POST",
    http_path = "/workspaces/{workspaceId}/apikeys",
    paginator = list()
  )
  input <- .managedgrafana$create_workspace_api_key_input(keyName = keyName, keyRole = keyRole, secondsToLive = secondsToLive, workspaceId = workspaceId)
  output <- .managedgrafana$create_workspace_api_key_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$create_workspace_api_key <- managedgrafana_create_workspace_api_key

#' Deletes an Amazon Managed Grafana workspace
#'
#' @description
#' Deletes an Amazon Managed Grafana workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_delete_workspace/](https://www.paws-r-sdk.com/docs/managedgrafana_delete_workspace/) for full documentation.
#'
#' @param workspaceId &#91;required&#93; The ID of the workspace to delete.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_delete_workspace
managedgrafana_delete_workspace <- function(workspaceId) {
  op <- new_operation(
    name = "DeleteWorkspace",
    http_method = "DELETE",
    http_path = "/workspaces/{workspaceId}",
    paginator = list()
  )
  input <- .managedgrafana$delete_workspace_input(workspaceId = workspaceId)
  output <- .managedgrafana$delete_workspace_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$delete_workspace <- managedgrafana_delete_workspace

#' Deletes a Grafana API key for the workspace
#'
#' @description
#' Deletes a Grafana API key for the workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_delete_workspace_api_key/](https://www.paws-r-sdk.com/docs/managedgrafana_delete_workspace_api_key/) for full documentation.
#'
#' @param keyName &#91;required&#93; The name of the API key to delete.
#' @param workspaceId &#91;required&#93; The ID of the workspace to delete.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_delete_workspace_api_key
managedgrafana_delete_workspace_api_key <- function(keyName, workspaceId) {
  op <- new_operation(
    name = "DeleteWorkspaceApiKey",
    http_method = "DELETE",
    http_path = "/workspaces/{workspaceId}/apikeys/{keyName}",
    paginator = list()
  )
  input <- .managedgrafana$delete_workspace_api_key_input(keyName = keyName, workspaceId = workspaceId)
  output <- .managedgrafana$delete_workspace_api_key_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$delete_workspace_api_key <- managedgrafana_delete_workspace_api_key

#' Displays information about one Amazon Managed Grafana workspace
#'
#' @description
#' Displays information about one Amazon Managed Grafana workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_describe_workspace/](https://www.paws-r-sdk.com/docs/managedgrafana_describe_workspace/) for full documentation.
#'
#' @param workspaceId &#91;required&#93; The ID of the workspace to display information about.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_describe_workspace
managedgrafana_describe_workspace <- function(workspaceId) {
  op <- new_operation(
    name = "DescribeWorkspace",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}",
    paginator = list()
  )
  input <- .managedgrafana$describe_workspace_input(workspaceId = workspaceId)
  output <- .managedgrafana$describe_workspace_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$describe_workspace <- managedgrafana_describe_workspace

#' Displays information about the authentication methods used in one Amazon
#' Managed Grafana workspace
#'
#' @description
#' Displays information about the authentication methods used in one Amazon Managed Grafana workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_describe_workspace_authentication/](https://www.paws-r-sdk.com/docs/managedgrafana_describe_workspace_authentication/) for full documentation.
#'
#' @param workspaceId &#91;required&#93; The ID of the workspace to return authentication information about.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_describe_workspace_authentication
managedgrafana_describe_workspace_authentication <- function(workspaceId) {
  op <- new_operation(
    name = "DescribeWorkspaceAuthentication",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}/authentication",
    paginator = list()
  )
  input <- .managedgrafana$describe_workspace_authentication_input(workspaceId = workspaceId)
  output <- .managedgrafana$describe_workspace_authentication_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$describe_workspace_authentication <- managedgrafana_describe_workspace_authentication

#' Gets the current configuration string for the given workspace
#'
#' @description
#' Gets the current configuration string for the given workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_describe_workspace_configuration/](https://www.paws-r-sdk.com/docs/managedgrafana_describe_workspace_configuration/) for full documentation.
#'
#' @param workspaceId &#91;required&#93; The ID of the workspace to get configuration information for.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_describe_workspace_configuration
managedgrafana_describe_workspace_configuration <- function(workspaceId) {
  op <- new_operation(
    name = "DescribeWorkspaceConfiguration",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}/configuration",
    paginator = list()
  )
  input <- .managedgrafana$describe_workspace_configuration_input(workspaceId = workspaceId)
  output <- .managedgrafana$describe_workspace_configuration_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$describe_workspace_configuration <- managedgrafana_describe_workspace_configuration

#' Removes the Grafana Enterprise license from a workspace
#'
#' @description
#' Removes the Grafana Enterprise license from a workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_disassociate_license/](https://www.paws-r-sdk.com/docs/managedgrafana_disassociate_license/) for full documentation.
#'
#' @param licenseType &#91;required&#93; The type of license to remove from the workspace.
#' @param workspaceId &#91;required&#93; The ID of the workspace to remove the Grafana Enterprise license from.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_disassociate_license
managedgrafana_disassociate_license <- function(licenseType, workspaceId) {
  op <- new_operation(
    name = "DisassociateLicense",
    http_method = "DELETE",
    http_path = "/workspaces/{workspaceId}/licenses/{licenseType}",
    paginator = list()
  )
  input <- .managedgrafana$disassociate_license_input(licenseType = licenseType, workspaceId = workspaceId)
  output <- .managedgrafana$disassociate_license_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$disassociate_license <- managedgrafana_disassociate_license

#' Lists the users and groups who have the Grafana Admin and Editor roles
#' in this workspace
#'
#' @description
#' Lists the users and groups who have the Grafana `Admin` and `Editor` roles in this workspace. If you use this operation without specifying `userId` or `groupId`, the operation returns the roles of all users and groups. If you specify a `userId` or a `groupId`, only the roles for that user or group are returned. If you do this, you can specify only one `userId` or one `groupId`.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_list_permissions/](https://www.paws-r-sdk.com/docs/managedgrafana_list_permissions/) for full documentation.
#'
#' @param groupId (Optional) Limits the results to only the group that matches this ID.
#' @param maxResults The maximum number of results to include in the response.
#' @param nextToken The token to use when requesting the next set of results. You received
#' this token from a previous
#' [`list_permissions`][managedgrafana_list_permissions] operation.
#' @param userId (Optional) Limits the results to only the user that matches this ID.
#' @param userType (Optional) If you specify `SSO_USER`, then only the permissions of IAM
#' Identity Center users are returned. If you specify `SSO_GROUP`, only the
#' permissions of IAM Identity Center groups are returned.
#' @param workspaceId &#91;required&#93; The ID of the workspace to list permissions for. This parameter is
#' required.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_list_permissions
managedgrafana_list_permissions <- function(groupId = NULL, maxResults = NULL, nextToken = NULL, userId = NULL, userType = NULL, workspaceId) {
  op <- new_operation(
    name = "ListPermissions",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}/permissions",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "permissions")
  )
  input <- .managedgrafana$list_permissions_input(groupId = groupId, maxResults = maxResults, nextToken = nextToken, userId = userId, userType = userType, workspaceId = workspaceId)
  output <- .managedgrafana$list_permissions_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$list_permissions <- managedgrafana_list_permissions

#' The ListTagsForResource operation returns the tags that are associated
#' with the Amazon Managed Service for Grafana resource specified by the
#' resourceArn
#'
#' @description
#' The [`list_tags_for_resource`][managedgrafana_list_tags_for_resource] operation returns the tags that are associated with the Amazon Managed Service for Grafana resource specified by the `resourceArn`. Currently, the only resource that can be tagged is a workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/managedgrafana_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource the list of tags are associated with.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_list_tags_for_resource
managedgrafana_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .managedgrafana$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .managedgrafana$list_tags_for_resource_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$list_tags_for_resource <- managedgrafana_list_tags_for_resource

#' Lists available versions of Grafana
#'
#' @description
#' Lists available versions of Grafana. These are available when calling [`create_workspace`][managedgrafana_create_workspace]. Optionally, include a workspace to list the versions to which it can be upgraded.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_list_versions/](https://www.paws-r-sdk.com/docs/managedgrafana_list_versions/) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response.
#' @param nextToken The token to use when requesting the next set of results. You receive
#' this token from a previous
#' [`list_versions`][managedgrafana_list_versions] operation.
#' @param workspaceId The ID of the workspace to list the available upgrade versions. If not
#' included, lists all versions of Grafana that are supported for
#' [`create_workspace`][managedgrafana_create_workspace].
#'
#' @keywords internal
#'
#' @rdname managedgrafana_list_versions
managedgrafana_list_versions <- function(maxResults = NULL, nextToken = NULL, workspaceId = NULL) {
  op <- new_operation(
    name = "ListVersions",
    http_method = "GET",
    http_path = "/versions",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "grafanaVersions")
  )
  input <- .managedgrafana$list_versions_input(maxResults = maxResults, nextToken = nextToken, workspaceId = workspaceId)
  output <- .managedgrafana$list_versions_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$list_versions <- managedgrafana_list_versions

#' Returns a list of Amazon Managed Grafana workspaces in the account, with
#' some information about each workspace
#'
#' @description
#' Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace. For more complete information about one workspace, use [`describe_workspace`][managedgrafana_describe_workspace].
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_list_workspaces/](https://www.paws-r-sdk.com/docs/managedgrafana_list_workspaces/) for full documentation.
#'
#' @param maxResults The maximum number of workspaces to include in the results.
#' @param nextToken The token for the next set of workspaces to return. (You receive this
#' token from a previous
#' [`list_workspaces`][managedgrafana_list_workspaces] operation.)
#'
#' @keywords internal
#'
#' @rdname managedgrafana_list_workspaces
managedgrafana_list_workspaces <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListWorkspaces",
    http_method = "GET",
    http_path = "/workspaces",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "workspaces")
  )
  input <- .managedgrafana$list_workspaces_input(maxResults = maxResults, nextToken = nextToken)
  output <- .managedgrafana$list_workspaces_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$list_workspaces <- managedgrafana_list_workspaces

#' The TagResource operation associates tags with an Amazon Managed Grafana
#' resource
#'
#' @description
#' The [`tag_resource`][managedgrafana_tag_resource] operation associates tags with an Amazon Managed Grafana resource. Currently, the only resource that can be tagged is workspaces.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_tag_resource/](https://www.paws-r-sdk.com/docs/managedgrafana_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource the tag is associated with.
#' @param tags &#91;required&#93; The list of tag keys and values to associate with the resource. You can
#' associate tag keys only, tags (key and values) only or a combination of
#' tag keys and tags.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_tag_resource
managedgrafana_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .managedgrafana$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .managedgrafana$tag_resource_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$tag_resource <- managedgrafana_tag_resource

#' The UntagResource operation removes the association of the tag with the
#' Amazon Managed Grafana resource
#'
#' @description
#' The [`untag_resource`][managedgrafana_untag_resource] operation removes the association of the tag with the Amazon Managed Grafana resource.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_untag_resource/](https://www.paws-r-sdk.com/docs/managedgrafana_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource the tag association is removed from.
#' @param tagKeys &#91;required&#93; The key values of the tag to be removed from the resource.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_untag_resource
managedgrafana_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .managedgrafana$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .managedgrafana$untag_resource_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$untag_resource <- managedgrafana_untag_resource

#' Updates which users in a workspace have the Grafana Admin or Editor
#' roles
#'
#' @description
#' Updates which users in a workspace have the Grafana `Admin` or `Editor` roles.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_update_permissions/](https://www.paws-r-sdk.com/docs/managedgrafana_update_permissions/) for full documentation.
#'
#' @param updateInstructionBatch &#91;required&#93; An array of structures that contain the permission updates to make.
#' @param workspaceId &#91;required&#93; The ID of the workspace to update.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_update_permissions
managedgrafana_update_permissions <- function(updateInstructionBatch, workspaceId) {
  op <- new_operation(
    name = "UpdatePermissions",
    http_method = "PATCH",
    http_path = "/workspaces/{workspaceId}/permissions",
    paginator = list()
  )
  input <- .managedgrafana$update_permissions_input(updateInstructionBatch = updateInstructionBatch, workspaceId = workspaceId)
  output <- .managedgrafana$update_permissions_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$update_permissions <- managedgrafana_update_permissions

#' Modifies an existing Amazon Managed Grafana workspace
#'
#' @description
#' Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional parameters, the existing values of those parameters are not changed.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_update_workspace/](https://www.paws-r-sdk.com/docs/managedgrafana_update_workspace/) for full documentation.
#'
#' @param accountAccessType Specifies whether the workspace can access Amazon Web Services resources
#' in this Amazon Web Services account only, or whether it can also access
#' Amazon Web Services resources in other accounts in the same
#' organization. If you specify `ORGANIZATION`, you must specify which
#' organizational units the workspace can access in the
#' `workspaceOrganizationalUnits` parameter.
#' @param networkAccessControl The configuration settings for network access to your workspace.
#' 
#' When this is configured, only listed IP addresses and VPC endpoints will
#' be able to access your workspace. Standard Grafana authentication and
#' authorization will still be required.
#' 
#' If this is not configured, or is removed, then all IP addresses and VPC
#' endpoints will be allowed. Standard Grafana authentication and
#' authorization will still be required.
#' @param organizationRoleName The name of an IAM role that already exists to use to access resources
#' through Organizations. This can only be used with a workspace that has
#' the `permissionType` set to `CUSTOMER_MANAGED`.
#' @param permissionType Use this parameter if you want to change a workspace from
#' `SERVICE_MANAGED` to `CUSTOMER_MANAGED`. This allows you to manage the
#' permissions that the workspace uses to access datasources and
#' notification channels. If the workspace is in a member Amazon Web
#' Services account of an organization, and that account is not a delegated
#' administrator account, and you want the workspace to access data sources
#' in other Amazon Web Services accounts in the organization, you must
#' choose `CUSTOMER_MANAGED`.
#' 
#' If you specify this as `CUSTOMER_MANAGED`, you must also specify a
#' `workspaceRoleArn` that the workspace will use for accessing Amazon Web
#' Services resources.
#' 
#' For more information on the role and permissions needed, see [Amazon
#' Managed Grafana permissions and policies for Amazon Web Services data
#' sources and notification
#' channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
#' 
#' Do not use this to convert a `CUSTOMER_MANAGED` workspace to
#' `SERVICE_MANAGED`. Do not include this parameter if you want to leave
#' the workspace as `SERVICE_MANAGED`.
#' 
#' You can convert a `CUSTOMER_MANAGED` workspace to `SERVICE_MANAGED`
#' using the Amazon Managed Grafana console. For more information, see
#' [Managing permissions for data sources and notification
#' channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html).
#' @param removeNetworkAccessConfiguration Whether to remove the network access configuration from the workspace.
#' 
#' Setting this to `true` and providing a `networkAccessControl` to set
#' will return an error.
#' 
#' If you remove this configuration by setting this to `true`, then all IP
#' addresses and VPC endpoints will be allowed. Standard Grafana
#' authentication and authorization will still be required.
#' @param removeVpcConfiguration Whether to remove the VPC configuration from the workspace.
#' 
#' Setting this to `true` and providing a `vpcConfiguration` to set will
#' return an error.
#' @param stackSetName The name of the CloudFormation stack set to use to generate IAM roles to
#' be used for this workspace.
#' @param vpcConfiguration The configuration settings for an Amazon VPC that contains data sources
#' for your Grafana workspace to connect to.
#' @param workspaceDataSources This parameter is for internal use only, and should not be used.
#' @param workspaceDescription A description for the workspace. This is used only to help you identify
#' this workspace.
#' @param workspaceId &#91;required&#93; The ID of the workspace to update.
#' @param workspaceName A new name for the workspace to update.
#' @param workspaceNotificationDestinations Specify the Amazon Web Services notification channels that you plan to
#' use in this workspace. Specifying these data sources here enables Amazon
#' Managed Grafana to create IAM roles and permissions that allow Amazon
#' Managed Grafana to use these channels.
#' @param workspaceOrganizationalUnits Specifies the organizational units that this workspace is allowed to use
#' data sources from, if this workspace is in an account that is part of an
#' organization.
#' @param workspaceRoleArn Specifies an IAM role that grants permissions to Amazon Web Services
#' resources that the workspace accesses, such as data sources and
#' notification channels. If this workspace has `permissionType`
#' `CUSTOMER_MANAGED`, then this role is required.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_update_workspace
managedgrafana_update_workspace <- function(accountAccessType = NULL, networkAccessControl = NULL, organizationRoleName = NULL, permissionType = NULL, removeNetworkAccessConfiguration = NULL, removeVpcConfiguration = NULL, stackSetName = NULL, vpcConfiguration = NULL, workspaceDataSources = NULL, workspaceDescription = NULL, workspaceId, workspaceName = NULL, workspaceNotificationDestinations = NULL, workspaceOrganizationalUnits = NULL, workspaceRoleArn = NULL) {
  op <- new_operation(
    name = "UpdateWorkspace",
    http_method = "PUT",
    http_path = "/workspaces/{workspaceId}",
    paginator = list()
  )
  input <- .managedgrafana$update_workspace_input(accountAccessType = accountAccessType, networkAccessControl = networkAccessControl, organizationRoleName = organizationRoleName, permissionType = permissionType, removeNetworkAccessConfiguration = removeNetworkAccessConfiguration, removeVpcConfiguration = removeVpcConfiguration, stackSetName = stackSetName, vpcConfiguration = vpcConfiguration, workspaceDataSources = workspaceDataSources, workspaceDescription = workspaceDescription, workspaceId = workspaceId, workspaceName = workspaceName, workspaceNotificationDestinations = workspaceNotificationDestinations, workspaceOrganizationalUnits = workspaceOrganizationalUnits, workspaceRoleArn = workspaceRoleArn)
  output <- .managedgrafana$update_workspace_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$update_workspace <- managedgrafana_update_workspace

#' Use this operation to define the identity provider (IdP) that this
#' workspace authenticates users from, using SAML
#'
#' @description
#' Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using SAML. You can also map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_update_workspace_authentication/](https://www.paws-r-sdk.com/docs/managedgrafana_update_workspace_authentication/) for full documentation.
#'
#' @param authenticationProviders &#91;required&#93; Specifies whether this workspace uses SAML 2.0, IAM Identity Center
#' (successor to Single Sign-On), or both to authenticate users for using
#' the Grafana console within a workspace. For more information, see [User
#' authentication in Amazon Managed
#' Grafana](https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html).
#' @param samlConfiguration If the workspace uses SAML, use this structure to map SAML assertion
#' attributes to workspace user information and define which groups in the
#' assertion attribute are to have the `Admin` and `Editor` roles in the
#' workspace.
#' @param workspaceId &#91;required&#93; The ID of the workspace to update the authentication for.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_update_workspace_authentication
managedgrafana_update_workspace_authentication <- function(authenticationProviders, samlConfiguration = NULL, workspaceId) {
  op <- new_operation(
    name = "UpdateWorkspaceAuthentication",
    http_method = "POST",
    http_path = "/workspaces/{workspaceId}/authentication",
    paginator = list()
  )
  input <- .managedgrafana$update_workspace_authentication_input(authenticationProviders = authenticationProviders, samlConfiguration = samlConfiguration, workspaceId = workspaceId)
  output <- .managedgrafana$update_workspace_authentication_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$update_workspace_authentication <- managedgrafana_update_workspace_authentication

#' Updates the configuration string for the given workspace
#'
#' @description
#' Updates the configuration string for the given workspace
#'
#' See [https://www.paws-r-sdk.com/docs/managedgrafana_update_workspace_configuration/](https://www.paws-r-sdk.com/docs/managedgrafana_update_workspace_configuration/) for full documentation.
#'
#' @param configuration &#91;required&#93; The new configuration string for the workspace. For more information
#' about the format and configuration options available, see [Working in
#' your Grafana
#' workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
#' @param grafanaVersion Specifies the version of Grafana to support in the new workspace.
#' 
#' Can only be used to upgrade (for example, from 8.4 to 9.4), not
#' downgrade (for example, from 9.4 to 8.4).
#' 
#' To know what versions are available to upgrade to for a specific
#' workspace, see the [`list_versions`][managedgrafana_list_versions]
#' operation.
#' @param workspaceId &#91;required&#93; The ID of the workspace to update.
#'
#' @keywords internal
#'
#' @rdname managedgrafana_update_workspace_configuration
managedgrafana_update_workspace_configuration <- function(configuration, grafanaVersion = NULL, workspaceId) {
  op <- new_operation(
    name = "UpdateWorkspaceConfiguration",
    http_method = "PUT",
    http_path = "/workspaces/{workspaceId}/configuration",
    paginator = list()
  )
  input <- .managedgrafana$update_workspace_configuration_input(configuration = configuration, grafanaVersion = grafanaVersion, workspaceId = workspaceId)
  output <- .managedgrafana$update_workspace_configuration_output()
  config <- get_config()
  svc <- .managedgrafana$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.managedgrafana$operations$update_workspace_configuration <- managedgrafana_update_workspace_configuration
