# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Synthetics
#'
#' @description
#' Amazon CloudWatch Synthetics
#' 
#' You can use Amazon CloudWatch Synthetics to continually monitor your
#' services. You can create and manage *canaries*, which are modular,
#' lightweight scripts that monitor your endpoints and APIs from the
#' outside-in. You can set up your canaries to run 24 hours a day, once per
#' minute. The canaries help you check the availability and latency of your
#' web services and troubleshoot anomalies by investigating load time data,
#' screenshots of the UI, logs, and metrics. The canaries seamlessly
#' integrate with CloudWatch ServiceLens to help you trace the causes of
#' impacted nodes in your applications. For more information, see [Using
#' ServiceLens to Monitor the Health of Your
#' Applications](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-servicemap.html)
#' in the *Amazon CloudWatch User Guide*.
#' 
#' Before you create and manage canaries, be aware of the security
#' considerations. For more information, see [Security Considerations for
#' Synthetics
#' Canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- synthetics(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- synthetics()
#' svc$associate_resource(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=synthetics_associate_resource]{associate_resource} \tab Associates a canary with a group\cr
#'  \link[=synthetics_create_canary]{create_canary} \tab Creates a canary\cr
#'  \link[=synthetics_create_group]{create_group} \tab Creates a group which you can use to associate canaries with each other, including cross-Region canaries\cr
#'  \link[=synthetics_delete_canary]{delete_canary} \tab Permanently deletes the specified canary\cr
#'  \link[=synthetics_delete_group]{delete_group} \tab Deletes a group\cr
#'  \link[=synthetics_describe_canaries]{describe_canaries} \tab This operation returns a list of the canaries in your account, along with full details about each canary\cr
#'  \link[=synthetics_describe_canaries_last_run]{describe_canaries_last_run} \tab Use this operation to see information from the most recent run of each canary that you have created\cr
#'  \link[=synthetics_describe_runtime_versions]{describe_runtime_versions} \tab Returns a list of Synthetics canary runtime versions\cr
#'  \link[=synthetics_disassociate_resource]{disassociate_resource} \tab Removes a canary from a group\cr
#'  \link[=synthetics_get_canary]{get_canary} \tab Retrieves complete information about one canary\cr
#'  \link[=synthetics_get_canary_runs]{get_canary_runs} \tab Retrieves a list of runs for a specified canary\cr
#'  \link[=synthetics_get_group]{get_group} \tab Returns information about one group\cr
#'  \link[=synthetics_list_associated_groups]{list_associated_groups} \tab Returns a list of the groups that the specified canary is associated with\cr
#'  \link[=synthetics_list_group_resources]{list_group_resources} \tab This operation returns a list of the ARNs of the canaries that are associated with the specified group\cr
#'  \link[=synthetics_list_groups]{list_groups} \tab Returns a list of all groups in the account, displaying their names, unique IDs, and ARNs\cr
#'  \link[=synthetics_list_tags_for_resource]{list_tags_for_resource} \tab Displays the tags associated with a canary or group\cr
#'  \link[=synthetics_start_canary]{start_canary} \tab Use this operation to run a canary that has already been created\cr
#'  \link[=synthetics_stop_canary]{stop_canary} \tab Stops the canary to prevent all future runs\cr
#'  \link[=synthetics_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified canary or group\cr
#'  \link[=synthetics_untag_resource]{untag_resource} \tab Removes one or more tags from the specified resource\cr
#'  \link[=synthetics_update_canary]{update_canary} \tab Updates the configuration of a canary that has already been created
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname synthetics
#' @export
synthetics <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .synthetics$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.synthetics <- list()

.synthetics$operations <- list()

.synthetics$metadata <- list(
  service_name = "synthetics",
  endpoints = list("*" = list(endpoint = "synthetics.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "synthetics.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "synthetics.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "synthetics.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "synthetics",
  api_version = "2017-10-11",
  signing_name = "synthetics",
  json_version = "1.1",
  target_prefix = ""
)

.synthetics$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.synthetics$metadata, handlers, config)
}
