% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controltower_operations.R
\name{controltower_disable_control}
\alias{controltower_disable_control}
\title{This API call turns off a control}
\usage{
controltower_disable_control(controlIdentifier, targetIdentifier)
}
\arguments{
\item{controlIdentifier}{[required] The ARN of the control. Only \strong{Strongly recommended} and \strong{Elective}
controls are permitted, with the exception of the \strong{landing zone Region
deny} control. For information on how to find the \code{controlIdentifier},
see \href{https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html}{the overview page}.}

\item{targetIdentifier}{[required] The ARN of the organizational unit. For information on how to find the
\code{targetIdentifier}, see \href{https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html}{the overview page}.}
}
\description{
This API call turns off a control. It starts an asynchronous operation that deletes Amazon Web Services resources on the specified organizational unit and the accounts it contains. The resources will vary according to the control that you specify. For usage examples, see \href{https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html}{\emph{the Amazon Web Services Control Tower User Guide}} .

See \url{https://www.paws-r-sdk.com/docs/controltower_disable_control/} for full documentation.
}
\keyword{internal}
