% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmcontacts_operations.R
\name{ssmcontacts_create_rotation}
\alias{ssmcontacts_create_rotation}
\title{Creates a rotation in an on-call schedule}
\usage{
ssmcontacts_create_rotation(
  Name,
  ContactIds,
  StartTime = NULL,
  TimeZoneId,
  Recurrence,
  Tags = NULL,
  IdempotencyToken = NULL
)
}
\arguments{
\item{Name}{[required] The name of the rotation.}

\item{ContactIds}{[required] The Amazon Resource Names (ARNs) of the contacts to add to the rotation.

The order that you list the contacts in is their shift order in the
rotation schedule. To change the order of the contact's shifts, use the
\code{\link[=ssmcontacts_update_rotation]{update_rotation}} operation.}

\item{StartTime}{The date and time that the rotation goes into effect.}

\item{TimeZoneId}{[required] The time zone to base the rotation’s activity on in Internet Assigned
Numbers Authority (IANA) format. For example: "America/Los_Angeles",
"UTC", or "Asia/Seoul". For more information, see the \href{https://www.iana.org/time-zones}{Time Zone Database} on the IANA website.

Designators for time zones that don’t support Daylight Savings Time
rules, such as Pacific Standard Time (PST) and Pacific Daylight Time
(PDT), are not supported.}

\item{Recurrence}{[required] Information about the rule that specifies when a shift's team members
rotate.}

\item{Tags}{Optional metadata to assign to the rotation. Tags enable you to
categorize a resource in different ways, such as by purpose, owner, or
environment. For more information, see \href{https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html}{Tagging Incident Manager resources}
in the \emph{Incident Manager User Guide}.}

\item{IdempotencyToken}{A token that ensures that the operation is called only once with the
specified details.}
}
\description{
Creates a rotation in an on-call schedule.

See \url{https://www.paws-r-sdk.com/docs/ssmcontacts_create_rotation/} for full documentation.
}
\keyword{internal}
