% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmcontacts_operations.R
\name{ssmcontacts_list_preview_rotation_shifts}
\alias{ssmcontacts_list_preview_rotation_shifts}
\title{Returns a list of shifts based on rotation configuration parameters}
\usage{
ssmcontacts_list_preview_rotation_shifts(
  RotationStartTime = NULL,
  StartTime = NULL,
  EndTime,
  Members,
  TimeZoneId,
  Recurrence,
  Overrides = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{RotationStartTime}{The date and time a rotation would begin. The first shift is calculated
from this date and time.}

\item{StartTime}{Used to filter the range of calculated shifts before sending the
response back to the user.}

\item{EndTime}{[required] The date and time a rotation shift would end.}

\item{Members}{[required] The contacts that would be assigned to a rotation.}

\item{TimeZoneId}{[required] The time zone the rotation’s activity would be based on, in Internet
Assigned Numbers Authority (IANA) format. For example:
"America/Los_Angeles", "UTC", or "Asia/Seoul".}

\item{Recurrence}{[required] Information about how long a rotation would last before restarting at
the beginning of the shift order.}

\item{Overrides}{Information about changes that would be made in a rotation override.}

\item{NextToken}{A token to start the list. This token is used to get the next set of
results.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that can be specified in a subsequent call to get the
next set of results.}
}
\description{
Returns a list of shifts based on rotation configuration parameters.

See \url{https://www.paws-r-sdk.com/docs/ssmcontacts_list_preview_rotation_shifts/} for full documentation.
}
\keyword{internal}
