# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudwatchobservabilityaccessmanager_service.R
NULL

#' Creates a link between a source account and a sink that you have created
#' in a monitoring account
#'
#' @description
#' Creates a link between a source account and a sink that you have created in a monitoring account. After the link is created, data is sent from the source account to the monitoring account. When you create a link, you can optionally specify filters that specify which metric namespaces and which log groups are shared from the source account to the monitoring account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_create_link/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_create_link/) for full documentation.
#'
#' @param LabelTemplate &#91;required&#93; Specify a friendly human-readable name to use to identify this source
#' account when you are viewing data from it in the monitoring account.
#' 
#' You can use a custom label or use the following variables:
#' 
#' -   `$AccountName` is the name of the account
#' 
#' -   `$AccountEmail` is the globally unique email address of the account
#' 
#' -   `$AccountEmailNoDomain` is the email address of the account without
#'     the domain name
#' @param LinkConfiguration Use this structure to optionally create filters that specify that only
#' some metric namespaces or log groups are to be shared from the source
#' account to the monitoring account.
#' @param ResourceTypes &#91;required&#93; An array of strings that define which types of data that the source
#' account shares with the monitoring account.
#' @param SinkIdentifier &#91;required&#93; The ARN of the sink to use to create this link. You can use
#' [`list_sinks`][cloudwatchobservabilityaccessmanager_list_sinks] to find
#' the ARNs of sinks.
#' 
#' For more information about sinks, see
#' [`create_sink`][cloudwatchobservabilityaccessmanager_create_sink].
#' @param Tags Assigns one or more tags (key-value pairs) to the link.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions by granting a user permission to
#' access or change only resources with certain tag values.
#' 
#' For more information about using tags to control access, see
#' [Controlling access to Amazon Web Services resources using
#' tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html).
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_create_link
cloudwatchobservabilityaccessmanager_create_link <- function(LabelTemplate, LinkConfiguration = NULL, ResourceTypes, SinkIdentifier, Tags = NULL) {
  op <- new_operation(
    name = "CreateLink",
    http_method = "POST",
    http_path = "/CreateLink",
    paginator = list()
  )
  input <- .cloudwatchobservabilityaccessmanager$create_link_input(LabelTemplate = LabelTemplate, LinkConfiguration = LinkConfiguration, ResourceTypes = ResourceTypes, SinkIdentifier = SinkIdentifier, Tags = Tags)
  output <- .cloudwatchobservabilityaccessmanager$create_link_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$create_link <- cloudwatchobservabilityaccessmanager_create_link

#' Use this to create a sink in the current account, so that it can be used
#' as a monitoring account in CloudWatch cross-account observability
#'
#' @description
#' Use this to create a *sink* in the current account, so that it can be used as a monitoring account in CloudWatch cross-account observability. A sink is a resource that represents an attachment point in a monitoring account. Source accounts can link to the sink to send observability data.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_create_sink/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_create_sink/) for full documentation.
#'
#' @param Name &#91;required&#93; A name for the sink.
#' @param Tags Assigns one or more tags (key-value pairs) to the link.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions by granting a user permission to
#' access or change only resources with certain tag values.
#' 
#' For more information about using tags to control access, see
#' [Controlling access to Amazon Web Services resources using
#' tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html).
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_create_sink
cloudwatchobservabilityaccessmanager_create_sink <- function(Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateSink",
    http_method = "POST",
    http_path = "/CreateSink",
    paginator = list()
  )
  input <- .cloudwatchobservabilityaccessmanager$create_sink_input(Name = Name, Tags = Tags)
  output <- .cloudwatchobservabilityaccessmanager$create_sink_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$create_sink <- cloudwatchobservabilityaccessmanager_create_sink

#' Deletes a link between a monitoring account sink and a source account
#'
#' @description
#' Deletes a link between a monitoring account sink and a source account. You must run this operation in the source account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_delete_link/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_delete_link/) for full documentation.
#'
#' @param Identifier &#91;required&#93; The ARN of the link to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_delete_link
cloudwatchobservabilityaccessmanager_delete_link <- function(Identifier) {
  op <- new_operation(
    name = "DeleteLink",
    http_method = "POST",
    http_path = "/DeleteLink",
    paginator = list()
  )
  input <- .cloudwatchobservabilityaccessmanager$delete_link_input(Identifier = Identifier)
  output <- .cloudwatchobservabilityaccessmanager$delete_link_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$delete_link <- cloudwatchobservabilityaccessmanager_delete_link

#' Deletes a sink
#'
#' @description
#' Deletes a sink. You must delete all links to a sink before you can delete that sink.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_delete_sink/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_delete_sink/) for full documentation.
#'
#' @param Identifier &#91;required&#93; The ARN of the sink to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_delete_sink
cloudwatchobservabilityaccessmanager_delete_sink <- function(Identifier) {
  op <- new_operation(
    name = "DeleteSink",
    http_method = "POST",
    http_path = "/DeleteSink",
    paginator = list()
  )
  input <- .cloudwatchobservabilityaccessmanager$delete_sink_input(Identifier = Identifier)
  output <- .cloudwatchobservabilityaccessmanager$delete_sink_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$delete_sink <- cloudwatchobservabilityaccessmanager_delete_sink

#' Returns complete information about one link
#'
#' @description
#' Returns complete information about one link.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_get_link/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_get_link/) for full documentation.
#'
#' @param Identifier &#91;required&#93; The ARN of the link to retrieve information for.
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_get_link
cloudwatchobservabilityaccessmanager_get_link <- function(Identifier) {
  op <- new_operation(
    name = "GetLink",
    http_method = "POST",
    http_path = "/GetLink",
    paginator = list()
  )
  input <- .cloudwatchobservabilityaccessmanager$get_link_input(Identifier = Identifier)
  output <- .cloudwatchobservabilityaccessmanager$get_link_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$get_link <- cloudwatchobservabilityaccessmanager_get_link

#' Returns complete information about one monitoring account sink
#'
#' @description
#' Returns complete information about one monitoring account sink.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_get_sink/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_get_sink/) for full documentation.
#'
#' @param Identifier &#91;required&#93; The ARN of the sink to retrieve information for.
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_get_sink
cloudwatchobservabilityaccessmanager_get_sink <- function(Identifier) {
  op <- new_operation(
    name = "GetSink",
    http_method = "POST",
    http_path = "/GetSink",
    paginator = list()
  )
  input <- .cloudwatchobservabilityaccessmanager$get_sink_input(Identifier = Identifier)
  output <- .cloudwatchobservabilityaccessmanager$get_sink_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$get_sink <- cloudwatchobservabilityaccessmanager_get_sink

#' Returns the current sink policy attached to this sink
#'
#' @description
#' Returns the current sink policy attached to this sink. The sink policy specifies what accounts can attach to this sink as source accounts, and what types of data they can share.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_get_sink_policy/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_get_sink_policy/) for full documentation.
#'
#' @param SinkIdentifier &#91;required&#93; The ARN of the sink to retrieve the policy of.
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_get_sink_policy
cloudwatchobservabilityaccessmanager_get_sink_policy <- function(SinkIdentifier) {
  op <- new_operation(
    name = "GetSinkPolicy",
    http_method = "POST",
    http_path = "/GetSinkPolicy",
    paginator = list()
  )
  input <- .cloudwatchobservabilityaccessmanager$get_sink_policy_input(SinkIdentifier = SinkIdentifier)
  output <- .cloudwatchobservabilityaccessmanager$get_sink_policy_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$get_sink_policy <- cloudwatchobservabilityaccessmanager_get_sink_policy

#' Returns a list of source account links that are linked to this
#' monitoring account sink
#'
#' @description
#' Returns a list of source account links that are linked to this monitoring account sink.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_list_attached_links/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_list_attached_links/) for full documentation.
#'
#' @param MaxResults Limits the number of returned links to the specified number.
#' @param NextToken The token for the next set of items to return. You received this token
#' from a previous call.
#' @param SinkIdentifier &#91;required&#93; The ARN of the sink that you want to retrieve links for.
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_list_attached_links
cloudwatchobservabilityaccessmanager_list_attached_links <- function(MaxResults = NULL, NextToken = NULL, SinkIdentifier) {
  op <- new_operation(
    name = "ListAttachedLinks",
    http_method = "POST",
    http_path = "/ListAttachedLinks",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Items")
  )
  input <- .cloudwatchobservabilityaccessmanager$list_attached_links_input(MaxResults = MaxResults, NextToken = NextToken, SinkIdentifier = SinkIdentifier)
  output <- .cloudwatchobservabilityaccessmanager$list_attached_links_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$list_attached_links <- cloudwatchobservabilityaccessmanager_list_attached_links

#' Use this operation in a source account to return a list of links to
#' monitoring account sinks that this source account has
#'
#' @description
#' Use this operation in a source account to return a list of links to monitoring account sinks that this source account has.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_list_links/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_list_links/) for full documentation.
#'
#' @param MaxResults Limits the number of returned links to the specified number.
#' @param NextToken The token for the next set of items to return. You received this token
#' from a previous call.
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_list_links
cloudwatchobservabilityaccessmanager_list_links <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListLinks",
    http_method = "POST",
    http_path = "/ListLinks",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Items")
  )
  input <- .cloudwatchobservabilityaccessmanager$list_links_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudwatchobservabilityaccessmanager$list_links_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$list_links <- cloudwatchobservabilityaccessmanager_list_links

#' Use this operation in a monitoring account to return the list of sinks
#' created in that account
#'
#' @description
#' Use this operation in a monitoring account to return the list of sinks created in that account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_list_sinks/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_list_sinks/) for full documentation.
#'
#' @param MaxResults Limits the number of returned links to the specified number.
#' @param NextToken The token for the next set of items to return. You received this token
#' from a previous call.
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_list_sinks
cloudwatchobservabilityaccessmanager_list_sinks <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSinks",
    http_method = "POST",
    http_path = "/ListSinks",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Items")
  )
  input <- .cloudwatchobservabilityaccessmanager$list_sinks_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudwatchobservabilityaccessmanager$list_sinks_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$list_sinks <- cloudwatchobservabilityaccessmanager_list_sinks

#' Displays the tags associated with a resource
#'
#' @description
#' Displays the tags associated with a resource. Both sinks and links support tagging.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource that you want to view tags for.
#' 
#' The ARN format of a sink is
#' `arn:aws:oam:Region:account-id:sink/sink-id `
#' 
#' The ARN format of a link is
#' `arn:aws:oam:Region:account-id:link/link-id `
#' 
#' For more information about ARN format, see [CloudWatch Logs resources
#' and
#' operations](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/iam-access-control-overview-cwl.html).
#' 
#' Unlike tagging permissions in other Amazon Web Services services, to
#' retrieve the list of tags for links or sinks you must have the
#' `oam:RequestTag` permission. The `aws:ReguestTag` permission does not
#' allow you to tag and untag links and sinks.
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_list_tags_for_resource
cloudwatchobservabilityaccessmanager_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .cloudwatchobservabilityaccessmanager$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .cloudwatchobservabilityaccessmanager$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$list_tags_for_resource <- cloudwatchobservabilityaccessmanager_list_tags_for_resource

#' Creates or updates the resource policy that grants permissions to source
#' accounts to link to the monitoring account sink
#'
#' @description
#' Creates or updates the resource policy that grants permissions to source accounts to link to the monitoring account sink. When you create a sink policy, you can grant permissions to all accounts in an organization or to individual accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_put_sink_policy/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_put_sink_policy/) for full documentation.
#'
#' @param Policy &#91;required&#93; The JSON policy to use. If you are updating an existing policy, the
#' entire existing policy is replaced by what you specify here.
#' 
#' The policy must be in JSON string format with quotation marks escaped
#' and no newlines.
#' 
#' For examples of different types of policies, see the **Examples**
#' section on this page.
#' @param SinkIdentifier &#91;required&#93; The ARN of the sink to attach this policy to.
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_put_sink_policy
cloudwatchobservabilityaccessmanager_put_sink_policy <- function(Policy, SinkIdentifier) {
  op <- new_operation(
    name = "PutSinkPolicy",
    http_method = "POST",
    http_path = "/PutSinkPolicy",
    paginator = list()
  )
  input <- .cloudwatchobservabilityaccessmanager$put_sink_policy_input(Policy = Policy, SinkIdentifier = SinkIdentifier)
  output <- .cloudwatchobservabilityaccessmanager$put_sink_policy_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$put_sink_policy <- cloudwatchobservabilityaccessmanager_put_sink_policy

#' Assigns one or more tags (key-value pairs) to the specified resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified resource. Both sinks and links can be tagged.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_tag_resource/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource that you're adding tags to.
#' 
#' The ARN format of a sink is
#' `arn:aws:oam:Region:account-id:sink/sink-id `
#' 
#' The ARN format of a link is
#' `arn:aws:oam:Region:account-id:link/link-id `
#' 
#' For more information about ARN format, see [CloudWatch Logs resources
#' and
#' operations](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/iam-access-control-overview-cwl.html).
#' @param Tags &#91;required&#93; The list of key-value pairs to associate with the resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_tag_resource
cloudwatchobservabilityaccessmanager_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "PUT",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .cloudwatchobservabilityaccessmanager$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .cloudwatchobservabilityaccessmanager$tag_resource_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$tag_resource <- cloudwatchobservabilityaccessmanager_tag_resource

#' Removes one or more tags from the specified resource
#'
#' @description
#' Removes one or more tags from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_untag_resource/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource that you're removing tags from.
#' 
#' The ARN format of a sink is
#' `arn:aws:oam:Region:account-id:sink/sink-id `
#' 
#' The ARN format of a link is
#' `arn:aws:oam:Region:account-id:link/link-id `
#' 
#' For more information about ARN format, see [CloudWatch Logs resources
#' and
#' operations](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/iam-access-control-overview-cwl.html).
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_untag_resource
cloudwatchobservabilityaccessmanager_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .cloudwatchobservabilityaccessmanager$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .cloudwatchobservabilityaccessmanager$untag_resource_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$untag_resource <- cloudwatchobservabilityaccessmanager_untag_resource

#' Use this operation to change what types of data are shared from a source
#' account to its linked monitoring account sink
#'
#' @description
#' Use this operation to change what types of data are shared from a source account to its linked monitoring account sink. You can't change the sink or change the monitoring account with this operation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_update_link/](https://www.paws-r-sdk.com/docs/cloudwatchobservabilityaccessmanager_update_link/) for full documentation.
#'
#' @param Identifier &#91;required&#93; The ARN of the link that you want to update.
#' @param LinkConfiguration Use this structure to filter which metric namespaces and which log
#' groups are to be shared from the source account to the monitoring
#' account.
#' @param ResourceTypes &#91;required&#93; An array of strings that define which types of data that the source
#' account will send to the monitoring account.
#' 
#' Your input here replaces the current set of data types that are shared.
#'
#' @keywords internal
#'
#' @rdname cloudwatchobservabilityaccessmanager_update_link
cloudwatchobservabilityaccessmanager_update_link <- function(Identifier, LinkConfiguration = NULL, ResourceTypes) {
  op <- new_operation(
    name = "UpdateLink",
    http_method = "POST",
    http_path = "/UpdateLink",
    paginator = list()
  )
  input <- .cloudwatchobservabilityaccessmanager$update_link_input(Identifier = Identifier, LinkConfiguration = LinkConfiguration, ResourceTypes = ResourceTypes)
  output <- .cloudwatchobservabilityaccessmanager$update_link_output()
  config <- get_config()
  svc <- .cloudwatchobservabilityaccessmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchobservabilityaccessmanager$operations$update_link <- cloudwatchobservabilityaccessmanager_update_link
